/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import java.io.Reader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Tokenizer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.CharFilterFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.TokenFilterFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.TokenizerFactory;

public final class CustomAnalyzer
extends Analyzer {
    private final String tokenizerName;
    private final TokenizerFactory tokenizerFactory;
    private final CharFilterFactory[] charFilters;
    private final TokenFilterFactory[] tokenFilters;
    private final int positionIncrementGap;
    private final int offsetGap;

    public CustomAnalyzer(String tokenizerName, TokenizerFactory tokenizerFactory, CharFilterFactory[] charFilters, TokenFilterFactory[] tokenFilters) {
        this(tokenizerName, tokenizerFactory, charFilters, tokenFilters, 0, -1);
    }

    public CustomAnalyzer(String tokenizerName, TokenizerFactory tokenizerFactory, CharFilterFactory[] charFilters, TokenFilterFactory[] tokenFilters, int positionIncrementGap, int offsetGap) {
        this.tokenizerName = tokenizerName;
        this.tokenizerFactory = tokenizerFactory;
        this.charFilters = charFilters;
        this.tokenFilters = tokenFilters;
        this.positionIncrementGap = positionIncrementGap;
        this.offsetGap = offsetGap;
    }

    public String getTokenizerName() {
        return this.tokenizerName;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.tokenizerFactory;
    }

    public TokenFilterFactory[] tokenFilters() {
        return this.tokenFilters;
    }

    public CharFilterFactory[] charFilters() {
        return this.charFilters;
    }

    @Override
    public int getPositionIncrementGap(String fieldName) {
        return this.positionIncrementGap;
    }

    @Override
    public int getOffsetGap(String field) {
        if (this.offsetGap < 0) {
            return super.getOffsetGap(field);
        }
        return this.offsetGap;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer tokenizer;
        TokenStream tokenStream = tokenizer = this.tokenizerFactory.create();
        for (TokenFilterFactory tokenFilter : this.tokenFilters) {
            tokenStream = tokenFilter.create(tokenStream);
        }
        return new Analyzer.TokenStreamComponents(tokenizer, tokenStream);
    }

    @Override
    protected Reader initReader(String fieldName, Reader reader) {
        if (this.charFilters != null && this.charFilters.length > 0) {
            for (CharFilterFactory charFilter : this.charFilters) {
                reader = charFilter.create(reader);
            }
        }
        return reader;
    }

    @Override
    protected Reader initReaderForNormalization(String fieldName, Reader reader) {
        for (CharFilterFactory charFilter : this.charFilters) {
            if (!(charFilter instanceof MultiTermAwareComponent)) continue;
            charFilter = (CharFilterFactory)((MultiTermAwareComponent)((Object)charFilter)).getMultiTermComponent();
            reader = charFilter.create(reader);
        }
        return reader;
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenStream result = in;
        for (TokenFilterFactory filter : this.tokenFilters) {
            if (!(filter instanceof MultiTermAwareComponent)) continue;
            filter = (TokenFilterFactory)((MultiTermAwareComponent)((Object)filter)).getMultiTermComponent();
            result = filter.create(result);
        }
        return result;
    }
}

