/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.MultiTermAwareComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.PreConfiguredAnalysisComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.TokenFilterFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public final class PreConfiguredTokenFilter
extends PreConfiguredAnalysisComponent<TokenFilterFactory> {
    private final boolean useFilterForMultitermQueries;
    private final BiFunction<TokenStream, Version, TokenStream> create;

    public static PreConfiguredTokenFilter singleton(String name, boolean useFilterForMultitermQueries, Function<TokenStream, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, PreBuiltCacheFactory.CachingStrategy.ONE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream));
    }

    public static PreConfiguredTokenFilter luceneVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, PreBuiltCacheFactory.CachingStrategy.LUCENE, (tokenStream, version) -> (TokenStream)create.apply((TokenStream)tokenStream, version.luceneVersion));
    }

    public static PreConfiguredTokenFilter elasticsearchVersion(String name, boolean useFilterForMultitermQueries, BiFunction<TokenStream, Version, TokenStream> create) {
        return new PreConfiguredTokenFilter(name, useFilterForMultitermQueries, PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH, create);
    }

    private PreConfiguredTokenFilter(String name, boolean useFilterForMultitermQueries, PreBuiltCacheFactory.CachingStrategy cache, BiFunction<TokenStream, Version, TokenStream> create) {
        super(name, cache);
        this.useFilterForMultitermQueries = useFilterForMultitermQueries;
        this.create = create;
    }

    public boolean shouldUseFilterForMultitermQueries() {
        return this.useFilterForMultitermQueries;
    }

    @Override
    protected TokenFilterFactory create(final Version version) {
        if (this.useFilterForMultitermQueries) {
            return new MultiTermAwareTokenFilterFactory(){

                @Override
                public String name() {
                    return PreConfiguredTokenFilter.this.getName();
                }

                @Override
                public TokenStream create(TokenStream tokenStream) {
                    return (TokenStream)PreConfiguredTokenFilter.this.create.apply(tokenStream, version);
                }

                @Override
                public Object getMultiTermComponent() {
                    return this;
                }
            };
        }
        return new TokenFilterFactory(){

            @Override
            public String name() {
                return PreConfiguredTokenFilter.this.getName();
            }

            @Override
            public TokenStream create(TokenStream tokenStream) {
                return (TokenStream)PreConfiguredTokenFilter.this.create.apply(tokenStream, version);
            }
        };
    }

    private static interface MultiTermAwareTokenFilterFactory
    extends TokenFilterFactory,
    MultiTermAwareComponent {
    }
}

