/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.similarity;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.similarities.Similarity;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.TriFunction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.similarity.ScriptedSimilarity;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.Script;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ScriptService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.SimilarityScript;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.SimilarityWeightScript;

final class ScriptedSimilarityProvider
implements TriFunction<Settings, Version, ScriptService, Similarity> {
    ScriptedSimilarityProvider() {
    }

    @Override
    public Similarity apply(Settings settings, Version indexCreatedVersion, ScriptService scriptService) {
        boolean discountOverlaps = settings.getAsBoolean("discount_overlaps", true);
        Settings scriptSettings = settings.getAsSettings("script");
        Script script = Script.parse(scriptSettings);
        SimilarityScript.Factory scriptFactory = scriptService.compile(script, SimilarityScript.CONTEXT);
        Settings weightScriptSettings = settings.getAsSettings("weight_script");
        Script weightScript = null;
        SimilarityWeightScript.Factory weightScriptFactory = null;
        if (!weightScriptSettings.isEmpty()) {
            weightScript = Script.parse(weightScriptSettings);
            weightScriptFactory = scriptService.compile(weightScript, SimilarityWeightScript.CONTEXT);
        }
        return new ScriptedSimilarity(weightScript == null ? null : weightScript.toString(), weightScriptFactory == null ? null : weightScriptFactory::newInstance, script.toString(), scriptFactory::newInstance, discountOverlaps);
    }
}

