/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.Action;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequestBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ContextPreservingActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateObserver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.ThreadContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.node.NodeClosedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent.CompletionPersistentTaskAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent.PersistentTaskParams;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent.RemovePersistentTaskAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent.StartPersistentTaskAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.persistent.UpdatePersistentTaskStatusAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.tasks.TaskId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;

public class PersistentTasksService
extends AbstractComponent {
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private static final String ACTION_ORIGIN_TRANSIENT_NAME = "action.origin";
    private static final String PERSISTENT_TASK_ORIGIN = "persistent_tasks";

    public PersistentTasksService(Settings settings, ClusterService clusterService, ThreadPool threadPool, Client client) {
        super(settings);
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public <Params extends PersistentTaskParams> void startPersistentTask(String taskId, String taskName, Params params, ActionListener<PersistentTasksCustomMetaData.PersistentTask<Params>> listener) {
        StartPersistentTaskAction.Request createPersistentActionRequest = new StartPersistentTaskAction.Request(taskId, taskName, params);
        try {
            PersistentTasksService.executeAsyncWithOrigin(this.client, PERSISTENT_TASK_ORIGIN, StartPersistentTaskAction.INSTANCE, createPersistentActionRequest, ActionListener.wrap(o -> listener.onResponse(o.getTask()), listener::onFailure));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void sendCompletionNotification(String taskId, long allocationId, Exception failure, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        CompletionPersistentTaskAction.Request restartRequest = new CompletionPersistentTaskAction.Request(taskId, allocationId, failure);
        try {
            PersistentTasksService.executeAsyncWithOrigin(this.client, PERSISTENT_TASK_ORIGIN, CompletionPersistentTaskAction.INSTANCE, restartRequest, ActionListener.wrap(o -> listener.onResponse(o.getTask()), listener::onFailure));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    void sendTaskManagerCancellation(long taskId, ActionListener<CancelTasksResponse> listener) {
        DiscoveryNode localNode = this.clusterService.localNode();
        CancelTasksRequest cancelTasksRequest = new CancelTasksRequest();
        cancelTasksRequest.setTaskId(new TaskId(localNode.getId(), taskId));
        cancelTasksRequest.setReason("persistent action was removed");
        try {
            PersistentTasksService.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), PERSISTENT_TASK_ORIGIN, cancelTasksRequest, listener, this.client.admin().cluster()::cancelTasks);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    void updateStatus(String taskId, long allocationId, Task.Status status, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        UpdatePersistentTaskStatusAction.Request updateStatusRequest = new UpdatePersistentTaskStatusAction.Request(taskId, allocationId, status);
        try {
            PersistentTasksService.executeAsyncWithOrigin(this.client, PERSISTENT_TASK_ORIGIN, UpdatePersistentTaskStatusAction.INSTANCE, updateStatusRequest, ActionListener.wrap(o -> listener.onResponse(o.getTask()), listener::onFailure));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void cancelPersistentTask(String taskId, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        RemovePersistentTaskAction.Request removeRequest = new RemovePersistentTaskAction.Request(taskId);
        try {
            PersistentTasksService.executeAsyncWithOrigin(this.client, PERSISTENT_TASK_ORIGIN, RemovePersistentTaskAction.INSTANCE, removeRequest, ActionListener.wrap(o -> listener.onResponse(o.getTask()), listener::onFailure));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void waitForPersistentTaskStatus(final String taskId, Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> predicate, @Nullable TimeValue timeout, final WaitForPersistentTaskStatusListener<?> listener) {
        ClusterStateObserver stateObserver = new ClusterStateObserver(this.clusterService, timeout, this.logger, this.threadPool.getThreadContext());
        if (predicate.test(PersistentTasksCustomMetaData.getTaskWithId(stateObserver.setAndGetObservedState(), taskId))) {
            listener.onResponse(PersistentTasksCustomMetaData.getTaskWithId(stateObserver.setAndGetObservedState(), taskId));
        } else {
            stateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    listener.onResponse(PersistentTasksCustomMetaData.getTaskWithId(state, taskId));
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onTimeout(timeout);
                }
            }, clusterState -> predicate.test(PersistentTasksCustomMetaData.getTaskWithId(clusterState, taskId)));
        }
    }

    public void waitForPersistentTasksStatus(Predicate<PersistentTasksCustomMetaData> predicate, @Nullable TimeValue timeout, final ActionListener<Boolean> listener) {
        ClusterStateObserver stateObserver = new ClusterStateObserver(this.clusterService, timeout, this.logger, this.threadPool.getThreadContext());
        if (predicate.test((PersistentTasksCustomMetaData)stateObserver.setAndGetObservedState().metaData().custom(PERSISTENT_TASK_ORIGIN))) {
            listener.onResponse(true);
        } else {
            stateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    listener.onResponse(true);
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onFailure(new IllegalStateException("timed out after " + timeout));
                }
            }, clusterState -> predicate.test((PersistentTasksCustomMetaData)clusterState.metaData().custom(PERSISTENT_TASK_ORIGIN)), timeout);
        }
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void executeAsyncWithOrigin(ThreadContext threadContext, String origin, Request request, ActionListener<Response> listener, BiConsumer<Request, ActionListener<Response>> consumer) {
        Supplier<ThreadContext.StoredContext> supplier = threadContext.newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = PersistentTasksService.stashWithOrigin(threadContext, origin);){
            consumer.accept(request, new ContextPreservingActionListener<Response>(supplier, listener));
        }
    }

    public static <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void executeAsyncWithOrigin(Client client, String origin, Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        ThreadContext threadContext = client.threadPool().getThreadContext();
        Supplier<ThreadContext.StoredContext> supplier = threadContext.newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = PersistentTasksService.stashWithOrigin(threadContext, origin);){
            client.execute(action, request, new ContextPreservingActionListener<Response>(supplier, listener));
        }
    }

    public static ThreadContext.StoredContext stashWithOrigin(ThreadContext threadContext, String origin) {
        ThreadContext.StoredContext storedContext = threadContext.stashContext();
        threadContext.putTransient(ACTION_ORIGIN_TRANSIENT_NAME, origin);
        return storedContext;
    }

    public static interface WaitForPersistentTaskStatusListener<Params extends PersistentTaskParams>
    extends ActionListener<PersistentTasksCustomMetaData.PersistentTask<Params>> {
        default public void onTimeout(TimeValue timeout) {
            this.onFailure(new IllegalStateException("timed out after " + timeout));
        }
    }
}

