/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MetaPluginInfo {
    static final String ES_META_PLUGIN_PROPERTIES = "meta-plugin-descriptor.properties";
    private final String name;
    private final String description;

    private MetaPluginInfo(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public static boolean isMetaPlugin(Path path) {
        return Files.exists(path.resolve(ES_META_PLUGIN_PROPERTIES), new LinkOption[0]);
    }

    public static boolean isPropertiesFile(Path path) {
        return ES_META_PLUGIN_PROPERTIES.equals(path.getFileName().toString());
    }

    public static MetaPluginInfo readFromProperties(Path path) throws IOException {
        Path descriptor = path.resolve(ES_META_PLUGIN_PROPERTIES);
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(descriptor, new OpenOption[0]);){
            props.load(stream);
        }
        Map propsMap = props.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), props::getProperty));
        String name = propsMap.remove("name");
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("property [name] is missing for meta plugin in [" + descriptor + "]");
        }
        String description = propsMap.remove("description");
        if (description == null) {
            throw new IllegalArgumentException("property [description] is missing for meta plugin [" + name + "]");
        }
        if (!propsMap.isEmpty()) {
            throw new IllegalArgumentException("Unknown properties in meta plugin descriptor: " + propsMap.keySet());
        }
        return new MetaPluginInfo(name, description);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaPluginInfo that = (MetaPluginInfo)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder information = new StringBuilder().append("- Plugin information:\n").append("Name: ").append(this.name).append("\n").append("Description: ").append(this.description);
        return information.toString();
    }
}

