/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.DoubleArray;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.SortedDocsProducer;

class DoubleValuesSource
extends SingleDimensionValuesSource<Double> {
    private final CheckedFunction<LeafReaderContext, SortedNumericDoubleValues, IOException> docValuesFunc;
    private final DoubleArray values;
    private double currentValue;

    DoubleValuesSource(BigArrays bigArrays, MappedFieldType fieldType, CheckedFunction<LeafReaderContext, SortedNumericDoubleValues, IOException> docValuesFunc, DocValueFormat format, Object missing, int size, int reverseMul) {
        super(format, fieldType, missing, size, reverseMul);
        this.docValuesFunc = docValuesFunc;
        this.values = bigArrays.newDoubleArray(size, false);
    }

    @Override
    void copyCurrent(int slot) {
        this.values.set(slot, this.currentValue);
    }

    @Override
    int compare(int from, int to) {
        return this.compareValues(this.values.get(from), this.values.get(to));
    }

    @Override
    int compareCurrent(int slot) {
        return this.compareValues(this.currentValue, this.values.get(slot));
    }

    @Override
    int compareCurrentWithAfter() {
        return this.compareValues(this.currentValue, (Double)this.afterValue);
    }

    private int compareValues(double v1, double v2) {
        return Double.compare(v1, v2) * this.reverseMul;
    }

    @Override
    void setAfter(Comparable<?> value) {
        this.afterValue = value instanceof Number ? Double.valueOf(((Number)((Object)value)).doubleValue()) : Double.valueOf(this.format.parseDouble(value.toString(), false, () -> {
            throw new IllegalArgumentException("now() is not supported in [after] key");
        }));
    }

    @Override
    Double toComparable(int slot) {
        return this.values.get(slot);
    }

    @Override
    LeafBucketCollector getLeafCollector(LeafReaderContext context, final LeafBucketCollector next) throws IOException {
        final SortedNumericDoubleValues dvs = this.docValuesFunc.apply(context);
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (dvs.advanceExact(doc)) {
                    int num = dvs.docValueCount();
                    for (int i = 0; i < num; ++i) {
                        DoubleValuesSource.this.currentValue = dvs.nextValue();
                        next.collect(doc, bucket);
                    }
                }
            }
        };
    }

    @Override
    LeafBucketCollector getLeafCollector(Comparable<?> value, LeafReaderContext context, final LeafBucketCollector next) {
        if (value.getClass() != Double.class) {
            throw new IllegalArgumentException("Expected Double, got " + value.getClass());
        }
        this.currentValue = (Double)value;
        return new LeafBucketCollector(){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                next.collect(doc, bucket);
            }
        };
    }

    @Override
    SortedDocsProducer createSortedDocsProducerOrNull(IndexReader reader, Query query) {
        return null;
    }

    @Override
    public void close() {
        Releasables.close(this.values);
    }
}

