/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.term;

import java.io.IOException;
import java.util.Comparator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.text.Text;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.SortBy;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.Suggest;

public class TermSuggestion
extends Suggest.Suggestion<Entry> {
    public static final String NAME = "term";
    public static final Comparator<Suggest.Suggestion.Entry.Option> SCORE = new Score();
    public static final Comparator<Suggest.Suggestion.Entry.Option> FREQUENCY = new Frequency();
    public static final int TYPE = 1;
    private SortBy sort;

    public TermSuggestion() {
    }

    public TermSuggestion(String name, int size, SortBy sort) {
        super(name, size);
        this.sort = sort;
    }

    @Override
    public int getWriteableType() {
        return 1;
    }

    @Override
    protected String getType() {
        return NAME;
    }

    @Override
    protected Comparator<Suggest.Suggestion.Entry.Option> sortComparator() {
        switch (this.sort) {
            case SCORE: {
                return SCORE;
            }
            case FREQUENCY: {
                return FREQUENCY;
            }
        }
        throw new ElasticsearchException("Could not resolve comparator for sort key: [" + this.sort + "]", new Object[0]);
    }

    @Override
    protected void innerReadFrom(StreamInput in) throws IOException {
        super.innerReadFrom(in);
        this.sort = SortBy.readFromStream(in);
    }

    @Override
    public void innerWriteTo(StreamOutput out) throws IOException {
        super.innerWriteTo(out);
        this.sort.writeTo(out);
    }

    public static TermSuggestion fromXContent(XContentParser parser, String name) throws IOException {
        TermSuggestion suggestion = new TermSuggestion(name, -1, SortBy.SCORE);
        TermSuggestion.parseEntries(parser, suggestion, Entry::fromXContent);
        return suggestion;
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    public static class Entry
    extends Suggest.Suggestion.Entry<Option> {
        private static ObjectParser<Entry, Void> PARSER = new ObjectParser("TermSuggestionEntryParser", true, Entry::new);

        public Entry(Text text, int offset, int length) {
            super(text, offset, length);
        }

        Entry() {
        }

        @Override
        protected Option newOption() {
            return new Option();
        }

        public static Entry fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        static {
            Entry.declareCommonFields(PARSER);
            PARSER.declareObjectArray(Suggest.Suggestion.Entry::addOptions, (p, c) -> Option.fromXContent(p), new ParseField("options", new String[0]));
        }

        public static class Option
        extends Suggest.Suggestion.Entry.Option {
            public static final ParseField FREQ = new ParseField("freq", new String[0]);
            private int freq;
            private static final ConstructingObjectParser<Option, Void> PARSER = new ConstructingObjectParser("TermSuggestionOptionParser", true, args -> {
                Text text = new Text((String)args[0]);
                int freq = (Integer)args[1];
                float score = ((Float)args[2]).floatValue();
                return new Option(text, freq, score);
            });

            public Option(Text text, int freq, float score) {
                super(text, score);
                this.freq = freq;
            }

            @Override
            protected void mergeInto(Suggest.Suggestion.Entry.Option otherOption) {
                super.mergeInto(otherOption);
                this.freq += ((Option)otherOption).freq;
            }

            protected Option() {
            }

            public void setFreq(int freq) {
                this.freq = freq;
            }

            public int getFreq() {
                return this.freq;
            }

            @Override
            public void readFrom(StreamInput in) throws IOException {
                super.readFrom(in);
                this.freq = in.readVInt();
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeVInt(this.freq);
            }

            @Override
            protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder = super.innerToXContent(builder, params);
                builder.field(FREQ.getPreferredName(), this.freq);
                return builder;
            }

            public static Option fromXContent(XContentParser parser) {
                return PARSER.apply(parser, null);
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), Suggest.Suggestion.Entry.Option.TEXT);
                PARSER.declareInt(ConstructingObjectParser.constructorArg(), FREQ);
                PARSER.declareFloat(ConstructingObjectParser.constructorArg(), Suggest.Suggestion.Entry.Option.SCORE);
            }
        }
    }

    public static class Frequency
    implements Comparator<Suggest.Suggestion.Entry.Option> {
        @Override
        public int compare(Suggest.Suggestion.Entry.Option first, Suggest.Suggestion.Entry.Option second) {
            int cmp = ((Entry.Option)second).getFreq() - ((Entry.Option)first).getFreq();
            if (cmp != 0) {
                return cmp;
            }
            cmp = Float.compare(second.getScore(), first.getScore());
            if (cmp != 0) {
                return cmp;
            }
            return first.getText().compareTo(second.getText());
        }
    }

    public static class Score
    implements Comparator<Suggest.Suggestion.Entry.Option> {
        @Override
        public int compare(Suggest.Suggestion.Entry.Option first, Suggest.Suggestion.Entry.Option second) {
            int cmp = Float.compare(second.getScore(), first.getScore());
            if (cmp != 0) {
                return cmp;
            }
            return FREQUENCY.compare(first, second);
        }
    }
}

