/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.api.java.io.jdbc.dialect.JDBCDialect;
import org.apache.flink.api.java.io.jdbc.dialect.JDBCDialects;
import org.apache.flink.util.Preconditions;

public class JDBCOptions {
    private String dbURL;
    private String tableName;
    private String driverName;
    private String username;
    private String password;
    private JDBCDialect dialect;

    private JDBCOptions(String dbURL, String tableName, String driverName, String username, String password, JDBCDialect dialect) {
        this.dbURL = dbURL;
        this.tableName = tableName;
        this.driverName = driverName;
        this.username = username;
        this.password = password;
        this.dialect = dialect;
    }

    public String getDbURL() {
        return this.dbURL;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public JDBCDialect getDialect() {
        return this.dialect;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o instanceof JDBCOptions) {
            JDBCOptions options = (JDBCOptions)o;
            return Objects.equals(this.dbURL, options.dbURL) && Objects.equals(this.tableName, options.tableName) && Objects.equals(this.driverName, options.driverName) && Objects.equals(this.username, options.username) && Objects.equals(this.password, options.password) && Objects.equals(this.dialect.getClass().getName(), options.dialect.getClass().getName());
        }
        return false;
    }

    public static class Builder {
        private String dbURL;
        private String tableName;
        private String driverName;
        private String username;
        private String password;
        private JDBCDialect dialect;

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setDriverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public Builder setDBUrl(String dbURL) {
            this.dbURL = dbURL;
            return this;
        }

        public Builder setDialect(JDBCDialect dialect) {
            this.dialect = dialect;
            return this;
        }

        public JDBCOptions build() {
            Optional<Object> optional;
            Preconditions.checkNotNull((Object)this.dbURL, (String)"No dbURL supplied.");
            Preconditions.checkNotNull((Object)this.tableName, (String)"No tableName supplied.");
            if (this.dialect == null) {
                optional = JDBCDialects.get(this.dbURL);
                this.dialect = optional.orElseGet(() -> {
                    throw new NullPointerException("No dialect supplied.");
                });
            }
            if (this.driverName == null) {
                optional = this.dialect.defaultDriverName();
                this.driverName = optional.orElseGet(() -> {
                    throw new NullPointerException("No driverName supplied.");
                });
            }
            return new JDBCOptions(this.dbURL, this.tableName, this.driverName, this.username, this.password, this.dialect);
        }
    }
}

