/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.java.io.jdbc.JDBCOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.types.Row;

class JDBCSinkFunction
extends RichSinkFunction<Row>
implements CheckpointedFunction {
    final JDBCOutputFormat outputFormat;

    JDBCSinkFunction(JDBCOutputFormat outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void invoke(Row value) throws Exception {
        this.outputFormat.writeRecord(value);
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        this.outputFormat.flush();
    }

    public void initializeState(FunctionInitializationContext context) throws Exception {
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        RuntimeContext ctx = this.getRuntimeContext();
        this.outputFormat.setRuntimeContext(ctx);
        this.outputFormat.open(ctx.getIndexOfThisSubtask(), ctx.getNumberOfParallelSubtasks());
    }

    public void close() throws Exception {
        this.outputFormat.close();
        super.close();
    }
}

