/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiSet;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashSet;

public class AlterReplicaLogDirsRequestData
implements ApiMessage {
    private AlterReplicaLogDirSet dirs = new AlterReplicaLogDirSet(0);
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public AlterReplicaLogDirsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public AlterReplicaLogDirsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public AlterReplicaLogDirsRequestData() {
    }

    @Override
    public short apiKey() {
        return 34;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.dirs.clear(0);
        } else {
            this.dirs.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.dirs.add(new AlterReplicaLogDir(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.dirs.size());
        for (AlterReplicaLogDir element : this.dirs) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("dirs");
        this.dirs = new AlterReplicaLogDirSet(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.dirs.add(new AlterReplicaLogDir((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.dirs.size()];
        int i = 0;
        for (AlterReplicaLogDir element : this.dirs) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("dirs", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        for (AlterReplicaLogDir element : this.dirs) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterReplicaLogDirsRequestData)) {
            return false;
        }
        AlterReplicaLogDirsRequestData other = (AlterReplicaLogDirsRequestData)obj;
        return !(this.dirs == null ? other.dirs != null : !this.dirs.equals(other.dirs));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.dirs == null ? 0 : this.dirs.hashCode());
        return hashCode;
    }

    public String toString() {
        return "AlterReplicaLogDirsRequestData(dirs=" + MessageUtil.deepToString(this.dirs.iterator()) + ")";
    }

    public AlterReplicaLogDirSet dirs() {
        return this.dirs;
    }

    public AlterReplicaLogDirsRequestData setDirs(AlterReplicaLogDirSet v) {
        this.dirs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("dirs", new ArrayOf(AlterReplicaLogDir.SCHEMA_0), "The alterations to make for each directory."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class AlterReplicaLogDirSet
    extends ImplicitLinkedHashMultiSet<AlterReplicaLogDir> {
        public AlterReplicaLogDirSet() {
        }

        public AlterReplicaLogDirSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterReplicaLogDirSet(Iterator<AlterReplicaLogDir> iterator) {
            super(iterator);
        }

        @Override
        public AlterReplicaLogDir find(String path) {
            AlterReplicaLogDir key = new AlterReplicaLogDir();
            key.setPath(path);
            return this.find(key);
        }

        @Override
        public List<AlterReplicaLogDir> findAll(String path) {
            AlterReplicaLogDir key = new AlterReplicaLogDir();
            key.setPath(path);
            return this.findAll(key);
        }
    }

    public static class AlterReplicaLogDirTopicSet
    extends ImplicitLinkedHashMultiSet<AlterReplicaLogDirTopic> {
        public AlterReplicaLogDirTopicSet() {
        }

        public AlterReplicaLogDirTopicSet(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterReplicaLogDirTopicSet(Iterator<AlterReplicaLogDirTopic> iterator) {
            super(iterator);
        }

        @Override
        public AlterReplicaLogDirTopic find(String name) {
            AlterReplicaLogDirTopic key = new AlterReplicaLogDirTopic();
            key.setName(name);
            return this.find(key);
        }

        @Override
        public List<AlterReplicaLogDirTopic> findAll(String name) {
            AlterReplicaLogDirTopic key = new AlterReplicaLogDirTopic();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class AlterReplicaLogDirTopic
    implements Message,
    ImplicitLinkedHashSet.Element {
        private String name;
        private List<Integer> partitions;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AlterReplicaLogDirTopic(Readable readable, short version) {
            this.partitions = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public AlterReplicaLogDirTopic(Struct struct, short version) {
            this.partitions = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public AlterReplicaLogDirTopic() {
            this.name = "";
            this.partitions = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions.clear();
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(readable.readInt());
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (Integer element : this.partitions) {
                writable.writeInt(element);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add((Integer)nestedObject);
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Integer[] nestedObjects = new Integer[this.partitions.size()];
            int i = 0;
            for (Integer element : this.partitions) {
                nestedObjects[i++] = element;
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            return size += this.partitions.size() * 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterReplicaLogDirTopic)) {
                return false;
            }
            AlterReplicaLogDirTopic other = (AlterReplicaLogDirTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AlterReplicaLogDirTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        public AlterReplicaLogDirTopic setName(String v) {
            this.name = v;
            return this;
        }

        public AlterReplicaLogDirTopic setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(Type.INT32), "The partition indexes."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class AlterReplicaLogDir
    implements Message,
    ImplicitLinkedHashSet.Element {
        private String path;
        private AlterReplicaLogDirTopicSet topics;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AlterReplicaLogDir(Readable readable, short version) {
            this.topics = new AlterReplicaLogDirTopicSet(0);
            this.read(readable, version);
        }

        public AlterReplicaLogDir(Struct struct, short version) {
            this.topics = new AlterReplicaLogDirTopicSet(0);
            this.fromStruct(struct, version);
        }

        public AlterReplicaLogDir() {
            this.path = "";
            this.topics = new AlterReplicaLogDirTopicSet(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.path = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.topics.clear(0);
            } else {
                this.topics.clear(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    this.topics.add(new AlterReplicaLogDirTopic(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.path);
            writable.writeInt(this.topics.size());
            for (AlterReplicaLogDirTopic element : this.topics) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.path = struct.getString("path");
            Object[] nestedObjects = struct.getArray("topics");
            this.topics = new AlterReplicaLogDirTopicSet(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.topics.add(new AlterReplicaLogDirTopic((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("path", (Object)this.path);
            Struct[] nestedObjects = new Struct[this.topics.size()];
            int i = 0;
            for (AlterReplicaLogDirTopic element : this.topics) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("topics", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.path);
            size += 4;
            for (AlterReplicaLogDirTopic element : this.topics) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterReplicaLogDir)) {
                return false;
            }
            AlterReplicaLogDir other = (AlterReplicaLogDir)obj;
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.path == null ? 0 : this.path.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AlterReplicaLogDir(path='" + this.path + "', topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
        }

        public String path() {
            return this.path;
        }

        public AlterReplicaLogDirTopicSet topics() {
            return this.topics;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        public AlterReplicaLogDir setPath(String v) {
            this.path = v;
            return this;
        }

        public AlterReplicaLogDir setTopics(AlterReplicaLogDirTopicSet v) {
            this.topics = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("path", Type.STRING, "The absolute directory path."), new Field("topics", new ArrayOf(AlterReplicaLogDirTopic.SCHEMA_0), "The topics to add to the directory."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

