/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;

public class CreateAclsRequestData
implements ApiMessage {
    private List<CreatableAcl> creations = new ArrayList<CreatableAcl>();
    public static final Schema SCHEMA_0 = new Schema(new Field("creations", new ArrayOf(CreatableAcl.SCHEMA_0), "The ACLs that we want to create."));
    public static final Schema SCHEMA_1 = new Schema(new Field("creations", new ArrayOf(CreatableAcl.SCHEMA_1), "The ACLs that we want to create."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

    public CreateAclsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public CreateAclsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public CreateAclsRequestData() {
    }

    @Override
    public short apiKey() {
        return 30;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.creations.clear();
        } else {
            this.creations.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.creations.add(new CreatableAcl(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.creations.size());
        for (CreatableAcl element : this.creations) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("creations");
        this.creations = new ArrayList<CreatableAcl>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.creations.add(new CreatableAcl((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.creations.size()];
        int i = 0;
        for (CreatableAcl element : this.creations) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("creations", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        for (CreatableAcl element : this.creations) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateAclsRequestData)) {
            return false;
        }
        CreateAclsRequestData other = (CreateAclsRequestData)obj;
        return !(this.creations == null ? other.creations != null : !this.creations.equals(other.creations));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.creations == null ? 0 : this.creations.hashCode());
        return hashCode;
    }

    public String toString() {
        return "CreateAclsRequestData(creations=" + MessageUtil.deepToString(this.creations.iterator()) + ")";
    }

    public List<CreatableAcl> creations() {
        return this.creations;
    }

    public CreateAclsRequestData setCreations(List<CreatableAcl> v) {
        this.creations = v;
        return this;
    }

    public static class CreatableAcl
    implements Message {
        private byte resourceType;
        private String resourceName;
        private byte resourcePatternType;
        private String principal;
        private String host;
        private byte operation;
        private byte permissionType;
        public static final Schema SCHEMA_0 = new Schema(new Field("resource_type", Type.INT8, "The type of the resource."), new Field("resource_name", Type.STRING, "The resource name for the ACL."), new Field("principal", Type.STRING, "The principal for the ACL."), new Field("host", Type.STRING, "The host for the ACL."), new Field("operation", Type.INT8, "The operation type for the ACL (read, write, etc.)."), new Field("permission_type", Type.INT8, "The permission type for the ACL (allow, deny, etc.)."));
        public static final Schema SCHEMA_1 = new Schema(new Field("resource_type", Type.INT8, "The type of the resource."), new Field("resource_name", Type.STRING, "The resource name for the ACL."), new Field("resource_pattern_type", Type.INT8, "The pattern type for the ACL."), new Field("principal", Type.STRING, "The principal for the ACL."), new Field("host", Type.STRING, "The host for the ACL."), new Field("operation", Type.INT8, "The operation type for the ACL (read, write, etc.)."), new Field("permission_type", Type.INT8, "The permission type for the ACL (allow, deny, etc.)."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

        public CreatableAcl(Readable readable, short version) {
            this.read(readable, version);
        }

        public CreatableAcl(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public CreatableAcl() {
            this.resourceType = 0;
            this.resourceName = "";
            this.resourcePatternType = (byte)3;
            this.principal = "";
            this.host = "";
            this.operation = 0;
            this.permissionType = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.resourceType = readable.readByte();
            this.resourceName = readable.readNullableString();
            this.resourcePatternType = version >= 1 ? readable.readByte() : (byte)3;
            this.principal = readable.readNullableString();
            this.host = readable.readNullableString();
            this.operation = readable.readByte();
            this.permissionType = readable.readByte();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeByte(this.resourceType);
            writable.writeString(this.resourceName);
            if (version >= 1) {
                writable.writeByte(this.resourcePatternType);
            }
            writable.writeString(this.principal);
            writable.writeString(this.host);
            writable.writeByte(this.operation);
            writable.writeByte(this.permissionType);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.resourceType = struct.getByte("resource_type");
            this.resourceName = struct.getString("resource_name");
            this.resourcePatternType = version >= 1 ? struct.getByte("resource_pattern_type") : (byte)3;
            this.principal = struct.getString("principal");
            this.host = struct.getString("host");
            this.operation = struct.getByte("operation");
            this.permissionType = struct.getByte("permission_type");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("resource_type", (Object)this.resourceType);
            struct.set("resource_name", (Object)this.resourceName);
            if (version >= 1) {
                struct.set("resource_pattern_type", (Object)this.resourcePatternType);
            }
            struct.set("principal", (Object)this.principal);
            struct.set("host", (Object)this.host);
            struct.set("operation", (Object)this.operation);
            struct.set("permission_type", (Object)this.permissionType);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            ++size;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.resourceName);
            if (version >= 1) {
                ++size;
            } else if (this.resourcePatternType != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default resourcePatternType at version " + version);
            }
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.principal);
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.host);
            ++size;
            return ++size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableAcl)) {
                return false;
            }
            CreatableAcl other = (CreatableAcl)obj;
            if (this.resourceType != other.resourceType) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            if (this.resourcePatternType != other.resourcePatternType) {
                return false;
            }
            if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            return this.permissionType == other.permissionType;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            hashCode = 31 * hashCode + this.resourcePatternType;
            hashCode = 31 * hashCode + (this.principal == null ? 0 : this.principal.hashCode());
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            return hashCode;
        }

        public String toString() {
            return "CreatableAcl(resourceType=" + this.resourceType + ", resourceName='" + this.resourceName + "', resourcePatternType=" + this.resourcePatternType + ", principal='" + this.principal + "', host='" + this.host + "', operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public byte resourcePatternType() {
            return this.resourcePatternType;
        }

        public String principal() {
            return this.principal;
        }

        public String host() {
            return this.host;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        public CreatableAcl setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public CreatableAcl setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public CreatableAcl setResourcePatternType(byte v) {
            this.resourcePatternType = v;
            return this;
        }

        public CreatableAcl setPrincipal(String v) {
            this.principal = v;
            return this;
        }

        public CreatableAcl setHost(String v) {
            this.host = v;
            return this;
        }

        public CreatableAcl setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public CreatableAcl setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }
    }
}

