/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Bytes;

public class ProduceRequestData
implements ApiMessage {
    private String transactionalId;
    private short acks;
    private int timeoutMs;
    private List<TopicProduceData> topics;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;

    public ProduceRequestData(Readable readable, short version) {
        this.topics = new ArrayList<TopicProduceData>();
        this.read(readable, version);
    }

    public ProduceRequestData(Struct struct, short version) {
        this.topics = new ArrayList<TopicProduceData>();
        this.fromStruct(struct, version);
    }

    public ProduceRequestData() {
        this.transactionalId = "";
        this.acks = 0;
        this.timeoutMs = 0;
        this.topics = new ArrayList<TopicProduceData>();
    }

    @Override
    public short apiKey() {
        return 0;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 7;
    }

    @Override
    public void read(Readable readable, short version) {
        this.transactionalId = version >= 3 ? readable.readNullableString() : "";
        this.acks = readable.readShort();
        this.timeoutMs = readable.readInt();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear();
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new TopicProduceData(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        if (version >= 3) {
            writable.writeNullableString(this.transactionalId);
        }
        writable.writeShort(this.acks);
        writable.writeInt(this.timeoutMs);
        writable.writeInt(this.topics.size());
        for (TopicProduceData element : this.topics) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.transactionalId = version >= 3 ? struct.getString("transactional_id") : "";
        this.acks = struct.getShort("acks");
        this.timeoutMs = struct.getInt("timeout_ms");
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<TopicProduceData>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new TopicProduceData((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 3) {
            struct.set("transactional_id", (Object)this.transactionalId);
        }
        struct.set("acks", (Object)this.acks);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (TopicProduceData element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        if (version >= 3) {
            size += 2;
            if (this.transactionalId != null) {
                size += MessageUtil.serializedUtf8Length(this.transactionalId);
            }
        } else if (this.transactionalId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default transactionalId at version " + version);
        }
        size += 2;
        size += 4;
        size += 4;
        for (TopicProduceData element : this.topics) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProduceRequestData)) {
            return false;
        }
        ProduceRequestData other = (ProduceRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.acks != other.acks) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + this.acks;
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "ProduceRequestData(transactionalId='" + this.transactionalId + "', acks=" + this.acks + ", timeoutMs=" + this.timeoutMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public short acks() {
        return this.acks;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public List<TopicProduceData> topics() {
        return this.topics;
    }

    public ProduceRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public ProduceRequestData setAcks(short v) {
        this.acks = v;
        return this;
    }

    public ProduceRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public ProduceRequestData setTopics(List<TopicProduceData> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("acks", Type.INT16, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. Allowed values: 0 for no acknowledgments, 1 for only the leader and -1 for the full ISR."), new Field("timeout_ms", Type.INT32, "The timeout to await a response in miliseconds."), new Field("topics", new ArrayOf(TopicProduceData.SCHEMA_0), "Each topic to produce to.")));
        SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = new Schema(new Field("transactional_id", Type.NULLABLE_STRING, "The transactional ID, or null if the producer is not transactional."), new Field("acks", Type.INT16, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. Allowed values: 0 for no acknowledgments, 1 for only the leader and -1 for the full ISR."), new Field("timeout_ms", Type.INT32, "The timeout to await a response in miliseconds."), new Field("topics", new ArrayOf(TopicProduceData.SCHEMA_0), "Each topic to produce to.")))));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class PartitionProduceData
    implements Message {
        private int partitionIndex;
        private byte[] records;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public PartitionProduceData(Readable readable, short version) {
            this.read(readable, version);
        }

        public PartitionProduceData(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public PartitionProduceData() {
            this.partitionIndex = 0;
            this.records = Bytes.EMPTY;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.records = readable.readNullableBytes();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeNullableBytes(this.records);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.records = struct.getByteArray("records");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.setByteArray("records", this.records);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 4;
            if (this.records != null) {
                size += this.records.length;
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionProduceData)) {
                return false;
            }
            PartitionProduceData other = (PartitionProduceData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return Arrays.equals(this.records, other.records);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + Arrays.hashCode(this.records);
            return hashCode;
        }

        public String toString() {
            return "PartitionProduceData(partitionIndex=" + this.partitionIndex + ", records=" + Arrays.toString(this.records) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public byte[] records() {
            return this.records;
        }

        public PartitionProduceData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionProduceData setRecords(byte[] v) {
            this.records = v;
            return this;
        }

        static {
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("records", Type.NULLABLE_BYTES, "The record data to be produced."))))))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }

    public static class TopicProduceData
    implements Message {
        private String name;
        private List<PartitionProduceData> partitions;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public TopicProduceData(Readable readable, short version) {
            this.partitions = new ArrayList<PartitionProduceData>();
            this.read(readable, version);
        }

        public TopicProduceData(Struct struct, short version) {
            this.partitions = new ArrayList<PartitionProduceData>();
            this.fromStruct(struct, version);
        }

        public TopicProduceData() {
            this.name = "";
            this.partitions = new ArrayList<PartitionProduceData>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions.clear();
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new PartitionProduceData(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (PartitionProduceData element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<PartitionProduceData>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new PartitionProduceData((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (PartitionProduceData element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (PartitionProduceData element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicProduceData)) {
                return false;
            }
            TopicProduceData other = (TopicProduceData)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "TopicProduceData(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<PartitionProduceData> partitions() {
            return this.partitions;
        }

        public TopicProduceData setName(String v) {
            this.name = v;
            return this;
        }

        public TopicProduceData setPartitions(List<PartitionProduceData> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(PartitionProduceData.SCHEMA_0), "Each partition to produce to."))))))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

