/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;

public class ProduceResponseData
implements ApiMessage {
    private List<TopicProduceResponse> responses = new ArrayList<TopicProduceResponse>();
    private int throttleTimeMs;
    public static final Schema SCHEMA_0 = new Schema(new Field("responses", new ArrayOf(TopicProduceResponse.SCHEMA_0), "Each produce response"));
    public static final Schema SCHEMA_1 = new Schema(new Field("responses", new ArrayOf(TopicProduceResponse.SCHEMA_0), "Each produce response"), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;

    public ProduceResponseData(Readable readable, short version) {
        this.read(readable, version);
    }

    public ProduceResponseData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public ProduceResponseData() {
        this.throttleTimeMs = 0;
    }

    @Override
    public short apiKey() {
        return 0;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 7;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.responses.clear();
        } else {
            this.responses.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.responses.add(new TopicProduceResponse(readable, version));
            }
        }
        this.throttleTimeMs = version >= 1 ? readable.readInt() : 0;
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.responses.size());
        for (TopicProduceResponse element : this.responses) {
            element.write(writable, version);
        }
        if (version >= 1) {
            writable.writeInt(this.throttleTimeMs);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("responses");
        this.responses = new ArrayList<TopicProduceResponse>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.responses.add(new TopicProduceResponse((Struct)nestedObject, version));
        }
        this.throttleTimeMs = version >= 1 ? struct.getInt("throttle_time_ms") : 0;
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.responses.size()];
        int i = 0;
        for (TopicProduceResponse element : this.responses) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("responses", (Object)nestedObjects);
        if (version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        for (TopicProduceResponse element : this.responses) {
            size += element.size(version);
        }
        if (version >= 1) {
            size += 4;
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProduceResponseData)) {
            return false;
        }
        ProduceResponseData other = (ProduceResponseData)obj;
        if (this.responses == null ? other.responses != null : !this.responses.equals(other.responses)) {
            return false;
        }
        return this.throttleTimeMs == other.throttleTimeMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.responses == null ? 0 : this.responses.hashCode());
        hashCode = 31 * hashCode + this.throttleTimeMs;
        return hashCode;
    }

    public String toString() {
        return "ProduceResponseData(responses=" + MessageUtil.deepToString(this.responses.iterator()) + ", throttleTimeMs=" + this.throttleTimeMs + ")";
    }

    public List<TopicProduceResponse> responses() {
        return this.responses;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public ProduceResponseData setResponses(List<TopicProduceResponse> v) {
        this.responses = v;
        return this;
    }

    public ProduceResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("responses", new ArrayOf(TopicProduceResponse.SCHEMA_2), "Each produce response"), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")));
        SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("responses", new ArrayOf(TopicProduceResponse.SCHEMA_5), "Each produce response"), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class PartitionProduceResponse
    implements Message {
        private int partitionIndex;
        private short errorCode;
        private long baseOffset;
        private long logAppendTimeMs;
        private long logStartOffset;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public PartitionProduceResponse(Readable readable, short version) {
            this.read(readable, version);
        }

        public PartitionProduceResponse(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public PartitionProduceResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.baseOffset = 0L;
            this.logAppendTimeMs = -1L;
            this.logStartOffset = -1L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.errorCode = readable.readShort();
            this.baseOffset = readable.readLong();
            this.logAppendTimeMs = version >= 2 ? readable.readLong() : -1L;
            this.logStartOffset = version >= 5 ? readable.readLong() : -1L;
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeShort(this.errorCode);
            writable.writeLong(this.baseOffset);
            if (version >= 2) {
                writable.writeLong(this.logAppendTimeMs);
            }
            if (version >= 5) {
                writable.writeLong(this.logStartOffset);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
            this.baseOffset = struct.getLong("base_offset");
            this.logAppendTimeMs = version >= 2 ? struct.getLong("log_append_time_ms") : -1L;
            this.logStartOffset = version >= 5 ? struct.getLong("log_start_offset") : -1L;
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("base_offset", (Object)this.baseOffset);
            if (version >= 2) {
                struct.set("log_append_time_ms", (Object)this.logAppendTimeMs);
            }
            if (version >= 5) {
                struct.set("log_start_offset", (Object)this.logStartOffset);
            }
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            size += 2;
            size += 8;
            if (version >= 2) {
                size += 8;
            }
            if (version >= 5) {
                size += 8;
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionProduceResponse)) {
                return false;
            }
            PartitionProduceResponse other = (PartitionProduceResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.baseOffset != other.baseOffset) {
                return false;
            }
            if (this.logAppendTimeMs != other.logAppendTimeMs) {
                return false;
            }
            return this.logStartOffset == other.logStartOffset;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + ((int)(this.baseOffset >> 32) ^ (int)this.baseOffset);
            hashCode = 31 * hashCode + ((int)(this.logAppendTimeMs >> 32) ^ (int)this.logAppendTimeMs);
            hashCode = 31 * hashCode + ((int)(this.logStartOffset >> 32) ^ (int)this.logStartOffset);
            return hashCode;
        }

        public String toString() {
            return "PartitionProduceResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", baseOffset=" + this.baseOffset + ", logAppendTimeMs=" + this.logAppendTimeMs + ", logStartOffset=" + this.logStartOffset + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public long logAppendTimeMs() {
            return this.logAppendTimeMs;
        }

        public long logStartOffset() {
            return this.logStartOffset;
        }

        public PartitionProduceResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionProduceResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionProduceResponse setBaseOffset(long v) {
            this.baseOffset = v;
            return this;
        }

        public PartitionProduceResponse setLogAppendTimeMs(long v) {
            this.logAppendTimeMs = v;
            return this;
        }

        public PartitionProduceResponse setLogStartOffset(long v) {
            this.logStartOffset = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", Type.INT64, "The base offset."));
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", Type.INT64, "The base offset."), new Field("log_append_time_ms", Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1.  If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended.")));
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", Type.INT64, "The base offset."), new Field("log_append_time_ms", Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1.  If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."), new Field("log_start_offset", Type.INT64, "The log start offset.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }

    public static class TopicProduceResponse
    implements Message {
        private String name;
        private List<PartitionProduceResponse> partitions;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;

        public TopicProduceResponse(Readable readable, short version) {
            this.partitions = new ArrayList<PartitionProduceResponse>();
            this.read(readable, version);
        }

        public TopicProduceResponse(Struct struct, short version) {
            this.partitions = new ArrayList<PartitionProduceResponse>();
            this.fromStruct(struct, version);
        }

        public TopicProduceResponse() {
            this.name = "";
            this.partitions = new ArrayList<PartitionProduceResponse>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions.clear();
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new PartitionProduceResponse(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (PartitionProduceResponse element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<PartitionProduceResponse>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new PartitionProduceResponse((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (PartitionProduceResponse element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (PartitionProduceResponse element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicProduceResponse)) {
                return false;
            }
            TopicProduceResponse other = (TopicProduceResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "TopicProduceResponse(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<PartitionProduceResponse> partitions() {
            return this.partitions;
        }

        public TopicProduceResponse setName(String v) {
            this.name = v;
            return this;
        }

        public TopicProduceResponse setPartitions(List<PartitionProduceResponse> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("partitions", new ArrayOf(PartitionProduceResponse.SCHEMA_0), "Each partition that we produced to within the topic."));
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("partitions", new ArrayOf(PartitionProduceResponse.SCHEMA_2), "Each partition that we produced to within the topic.")));
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("partitions", new ArrayOf(PartitionProduceResponse.SCHEMA_5), "Each partition that we produced to within the topic.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

