/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;

public class StopReplicaResponseData
implements ApiMessage {
    private short errorCode;
    private List<StopReplicaResponsePartition> partitions;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public StopReplicaResponseData(Readable readable, short version) {
        this.partitions = new ArrayList<StopReplicaResponsePartition>();
        this.read(readable, version);
    }

    public StopReplicaResponseData(Struct struct, short version) {
        this.partitions = new ArrayList<StopReplicaResponsePartition>();
        this.fromStruct(struct, version);
    }

    public StopReplicaResponseData() {
        this.errorCode = 0;
        this.partitions = new ArrayList<StopReplicaResponsePartition>();
    }

    @Override
    public short apiKey() {
        return 5;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.errorCode = readable.readShort();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.partitions.clear();
        } else {
            this.partitions.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.partitions.add(new StopReplicaResponsePartition(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeShort(this.errorCode);
        writable.writeInt(this.partitions.size());
        for (StopReplicaResponsePartition element : this.partitions) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.errorCode = struct.getShort("error_code");
        Object[] nestedObjects = struct.getArray("partitions");
        this.partitions = new ArrayList<StopReplicaResponsePartition>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.partitions.add(new StopReplicaResponsePartition((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("error_code", (Object)this.errorCode);
        Struct[] nestedObjects = new Struct[this.partitions.size()];
        int i = 0;
        for (StopReplicaResponsePartition element : this.partitions) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("partitions", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += 4;
        for (StopReplicaResponsePartition element : this.partitions) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StopReplicaResponseData)) {
            return false;
        }
        StopReplicaResponseData other = (StopReplicaResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
        return hashCode;
    }

    public String toString() {
        return "StopReplicaResponseData(errorCode=" + this.errorCode + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<StopReplicaResponsePartition> partitions() {
        return this.partitions;
    }

    public StopReplicaResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public StopReplicaResponseData setPartitions(List<StopReplicaResponsePartition> v) {
        this.partitions = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no top-level error."), new Field("partitions", new ArrayOf(StopReplicaResponsePartition.SCHEMA_0), "The responses for each partition."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class StopReplicaResponsePartition
    implements Message {
        private String topicName;
        private int partitionIndex;
        private short errorCode;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public StopReplicaResponsePartition(Readable readable, short version) {
            this.read(readable, version);
        }

        public StopReplicaResponsePartition(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public StopReplicaResponsePartition() {
            this.topicName = "";
            this.partitionIndex = 0;
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable readable, short version) {
            this.topicName = readable.readNullableString();
            this.partitionIndex = readable.readInt();
            this.errorCode = readable.readShort();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.topicName);
            writable.writeInt(this.partitionIndex);
            writable.writeShort(this.errorCode);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.topicName = struct.getString("topic_name");
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("topic_name", (Object)this.topicName);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.topicName);
            size += 4;
            return size += 2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopReplicaResponsePartition)) {
                return false;
            }
            StopReplicaResponsePartition other = (StopReplicaResponsePartition)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return this.errorCode == other.errorCode;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            return hashCode;
        }

        public String toString() {
            return "StopReplicaResponsePartition(topicName='" + this.topicName + "', partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public StopReplicaResponsePartition setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public StopReplicaResponsePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public StopReplicaResponsePartition setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no partition error."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

