/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.config.ConfigResource;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ApiError;

public class DescribeConfigsResponse
extends AbstractResponse {
    private static final String RESOURCES_KEY_NAME = "resources";
    private static final String RESOURCE_TYPE_KEY_NAME = "resource_type";
    private static final String RESOURCE_NAME_KEY_NAME = "resource_name";
    private static final String CONFIG_ENTRIES_KEY_NAME = "config_entries";
    private static final String CONFIG_NAME_KEY_NAME = "config_name";
    private static final String CONFIG_VALUE_KEY_NAME = "config_value";
    private static final String IS_SENSITIVE_KEY_NAME = "is_sensitive";
    private static final String IS_DEFAULT_KEY_NAME = "is_default";
    private static final String READ_ONLY_KEY_NAME = "read_only";
    private static final String CONFIG_SYNONYMS_KEY_NAME = "config_synonyms";
    private static final String CONFIG_SOURCE_KEY_NAME = "config_source";
    private static final Schema DESCRIBE_CONFIGS_RESPONSE_ENTRY_V0 = new Schema(new Field("config_name", Type.STRING), new Field("config_value", Type.NULLABLE_STRING), new Field("read_only", Type.BOOLEAN), new Field("is_default", Type.BOOLEAN), new Field("is_sensitive", Type.BOOLEAN));
    private static final Schema DESCRIBE_CONFIGS_RESPONSE_SYNONYM_V1 = new Schema(new Field("config_name", Type.STRING), new Field("config_value", Type.NULLABLE_STRING), new Field("config_source", Type.INT8));
    private static final Schema DESCRIBE_CONFIGS_RESPONSE_ENTRY_V1 = new Schema(new Field("config_name", Type.STRING), new Field("config_value", Type.NULLABLE_STRING), new Field("read_only", Type.BOOLEAN), new Field("config_source", Type.INT8), new Field("is_sensitive", Type.BOOLEAN), new Field("config_synonyms", new ArrayOf(DESCRIBE_CONFIGS_RESPONSE_SYNONYM_V1)));
    private static final Schema DESCRIBE_CONFIGS_RESPONSE_ENTITY_V0 = new Schema(CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("resource_type", Type.INT8), new Field("resource_name", Type.STRING), new Field("config_entries", new ArrayOf(DESCRIBE_CONFIGS_RESPONSE_ENTRY_V0)));
    private static final Schema DESCRIBE_CONFIGS_RESPONSE_ENTITY_V1 = new Schema(CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("resource_type", Type.INT8), new Field("resource_name", Type.STRING), new Field("config_entries", new ArrayOf(DESCRIBE_CONFIGS_RESPONSE_ENTRY_V1)));
    private static final Schema DESCRIBE_CONFIGS_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field("resources", new ArrayOf(DESCRIBE_CONFIGS_RESPONSE_ENTITY_V0)));
    private static final Schema DESCRIBE_CONFIGS_RESPONSE_V1;
    private static final Schema DESCRIBE_CONFIGS_RESPONSE_V2;
    private final int throttleTimeMs;
    private final Map<ConfigResource, Config> configs;

    public static Schema[] schemaVersions() {
        return new Schema[]{DESCRIBE_CONFIGS_RESPONSE_V0, DESCRIBE_CONFIGS_RESPONSE_V1, DESCRIBE_CONFIGS_RESPONSE_V2};
    }

    public DescribeConfigsResponse(int throttleTimeMs, Map<ConfigResource, Config> configs) {
        this.throttleTimeMs = throttleTimeMs;
        this.configs = Objects.requireNonNull(configs, "configs");
    }

    public DescribeConfigsResponse(Struct struct) {
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        Object[] resourcesArray = struct.getArray(RESOURCES_KEY_NAME);
        this.configs = new HashMap<ConfigResource, Config>(resourcesArray.length);
        for (Object resourceObj : resourcesArray) {
            Struct resourceStruct = (Struct)resourceObj;
            ApiError error = new ApiError(resourceStruct);
            ConfigResource.Type resourceType = ConfigResource.Type.forId(resourceStruct.getByte(RESOURCE_TYPE_KEY_NAME));
            String resourceName = resourceStruct.getString(RESOURCE_NAME_KEY_NAME);
            ConfigResource resource = new ConfigResource(resourceType, resourceName);
            Object[] configEntriesArray = resourceStruct.getArray(CONFIG_ENTRIES_KEY_NAME);
            ArrayList<ConfigEntry> configEntries = new ArrayList<ConfigEntry>(configEntriesArray.length);
            for (Object configEntriesObj : configEntriesArray) {
                List<ConfigSynonym> synonyms;
                ConfigSource configSource;
                Struct configEntriesStruct = (Struct)configEntriesObj;
                String configName = configEntriesStruct.getString(CONFIG_NAME_KEY_NAME);
                String configValue = configEntriesStruct.getString(CONFIG_VALUE_KEY_NAME);
                boolean isSensitive = configEntriesStruct.getBoolean(IS_SENSITIVE_KEY_NAME);
                if (configEntriesStruct.hasField(CONFIG_SOURCE_KEY_NAME)) {
                    configSource = ConfigSource.forId(configEntriesStruct.getByte(CONFIG_SOURCE_KEY_NAME));
                } else if (configEntriesStruct.hasField(IS_DEFAULT_KEY_NAME)) {
                    if (configEntriesStruct.getBoolean(IS_DEFAULT_KEY_NAME).booleanValue()) {
                        configSource = ConfigSource.DEFAULT_CONFIG;
                    } else {
                        switch (resourceType) {
                            case BROKER: {
                                configSource = ConfigSource.STATIC_BROKER_CONFIG;
                                break;
                            }
                            case TOPIC: {
                                configSource = ConfigSource.TOPIC_CONFIG;
                                break;
                            }
                            default: {
                                configSource = ConfigSource.UNKNOWN_CONFIG;
                                break;
                            }
                        }
                    }
                } else {
                    throw new IllegalStateException("Config entry should contain either is_default or config_source");
                }
                boolean readOnly = configEntriesStruct.getBoolean(READ_ONLY_KEY_NAME);
                if (configEntriesStruct.hasField(CONFIG_SYNONYMS_KEY_NAME)) {
                    Object[] synonymsArray = configEntriesStruct.getArray(CONFIG_SYNONYMS_KEY_NAME);
                    synonyms = new ArrayList(synonymsArray.length);
                    for (Object synonymObj : synonymsArray) {
                        Struct synonymStruct = (Struct)synonymObj;
                        String synonymConfigName = synonymStruct.getString(CONFIG_NAME_KEY_NAME);
                        String synonymConfigValue = synonymStruct.getString(CONFIG_VALUE_KEY_NAME);
                        ConfigSource source = ConfigSource.forId(synonymStruct.getByte(CONFIG_SOURCE_KEY_NAME));
                        synonyms.add(new ConfigSynonym(synonymConfigName, synonymConfigValue, source));
                    }
                } else {
                    synonyms = Collections.emptyList();
                }
                configEntries.add(new ConfigEntry(configName, configValue, configSource, isSensitive, readOnly, synonyms));
            }
            Config config = new Config(error, configEntries);
            this.configs.put(resource, config);
        }
    }

    public Map<ConfigResource, Config> configs() {
        return this.configs;
    }

    public Config config(ConfigResource resource) {
        return this.configs.get(resource);
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (Config response : this.configs.values()) {
            this.updateErrorCounts(errorCounts, response.error.error());
        }
        return errorCounts;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DESCRIBE_CONFIGS.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        ArrayList<Struct> resourceStructs = new ArrayList<Struct>(this.configs.size());
        for (Map.Entry<ConfigResource, Config> entry : this.configs.entrySet()) {
            Struct resourceStruct = struct.instance(RESOURCES_KEY_NAME);
            ConfigResource resource = entry.getKey();
            resourceStruct.set(RESOURCE_TYPE_KEY_NAME, (Object)resource.type().id());
            resourceStruct.set(RESOURCE_NAME_KEY_NAME, (Object)resource.name());
            Config config = entry.getValue();
            config.error.write(resourceStruct);
            ArrayList<Struct> configEntryStructs = new ArrayList<Struct>(config.entries.size());
            for (ConfigEntry configEntry : config.entries) {
                Struct configEntriesStruct = resourceStruct.instance(CONFIG_ENTRIES_KEY_NAME);
                configEntriesStruct.set(CONFIG_NAME_KEY_NAME, (Object)configEntry.name);
                configEntriesStruct.set(CONFIG_VALUE_KEY_NAME, (Object)configEntry.value);
                configEntriesStruct.set(IS_SENSITIVE_KEY_NAME, (Object)configEntry.isSensitive);
                configEntriesStruct.setIfExists(CONFIG_SOURCE_KEY_NAME, (Object)((ConfigEntry)configEntry).source.id);
                configEntriesStruct.setIfExists(IS_DEFAULT_KEY_NAME, (Object)(configEntry.source == ConfigSource.DEFAULT_CONFIG ? 1 : 0));
                configEntriesStruct.set(READ_ONLY_KEY_NAME, (Object)configEntry.readOnly);
                configEntryStructs.add(configEntriesStruct);
                if (!configEntriesStruct.hasField(CONFIG_SYNONYMS_KEY_NAME)) continue;
                ArrayList<Struct> configSynonymStructs = new ArrayList<Struct>(configEntry.synonyms.size());
                for (ConfigSynonym synonym : configEntry.synonyms) {
                    Struct configSynonymStruct = configEntriesStruct.instance(CONFIG_SYNONYMS_KEY_NAME);
                    configSynonymStruct.set(CONFIG_NAME_KEY_NAME, (Object)synonym.name);
                    configSynonymStruct.set(CONFIG_VALUE_KEY_NAME, (Object)synonym.value);
                    configSynonymStruct.set(CONFIG_SOURCE_KEY_NAME, (Object)((ConfigSynonym)synonym).source.id);
                    configSynonymStructs.add(configSynonymStruct);
                }
                configEntriesStruct.set(CONFIG_SYNONYMS_KEY_NAME, (Object)configSynonymStructs.toArray(new Struct[0]));
            }
            resourceStruct.set(CONFIG_ENTRIES_KEY_NAME, (Object)configEntryStructs.toArray(new Struct[0]));
            resourceStructs.add(resourceStruct);
        }
        struct.set(RESOURCES_KEY_NAME, (Object)resourceStructs.toArray(new Struct[0]));
        return struct;
    }

    public static DescribeConfigsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeConfigsResponse(ApiKeys.DESCRIBE_CONFIGS.parseResponse(version, buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    static {
        DESCRIBE_CONFIGS_RESPONSE_V2 = DESCRIBE_CONFIGS_RESPONSE_V1 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(RESOURCES_KEY_NAME, new ArrayOf(DESCRIBE_CONFIGS_RESPONSE_ENTITY_V1)));
    }

    public static class ConfigSynonym {
        private final String name;
        private final String value;
        private final ConfigSource source;

        public ConfigSynonym(String name, String value, ConfigSource source) {
            this.name = Objects.requireNonNull(name, "name");
            this.value = value;
            this.source = Objects.requireNonNull(source, "source");
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public ConfigSource source() {
            return this.source;
        }
    }

    public static enum ConfigSource {
        UNKNOWN_CONFIG(0),
        TOPIC_CONFIG(1),
        DYNAMIC_BROKER_CONFIG(2),
        DYNAMIC_DEFAULT_BROKER_CONFIG(3),
        STATIC_BROKER_CONFIG(4),
        DEFAULT_CONFIG(5);

        final byte id;
        private static final ConfigSource[] VALUES;

        private ConfigSource(byte id) {
            this.id = id;
        }

        public static ConfigSource forId(byte id) {
            if (id < 0) {
                throw new IllegalArgumentException("id should be positive, id: " + id);
            }
            if (id >= VALUES.length) {
                return UNKNOWN_CONFIG;
            }
            return VALUES[id];
        }

        static {
            VALUES = ConfigSource.values();
        }
    }

    public static class ConfigEntry {
        private final String name;
        private final String value;
        private final boolean isSensitive;
        private final ConfigSource source;
        private final boolean readOnly;
        private final Collection<ConfigSynonym> synonyms;

        public ConfigEntry(String name, String value, ConfigSource source, boolean isSensitive, boolean readOnly, Collection<ConfigSynonym> synonyms) {
            this.name = Objects.requireNonNull(name, "name");
            this.value = value;
            this.source = Objects.requireNonNull(source, "source");
            this.isSensitive = isSensitive;
            this.readOnly = readOnly;
            this.synonyms = Objects.requireNonNull(synonyms, "synonyms");
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public boolean isSensitive() {
            return this.isSensitive;
        }

        public ConfigSource source() {
            return this.source;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public Collection<ConfigSynonym> synonyms() {
            return this.synonyms;
        }
    }

    public static class Config {
        private final ApiError error;
        private final Collection<ConfigEntry> entries;

        public Config(ApiError error, Collection<ConfigEntry> entries) {
            this.error = Objects.requireNonNull(error, "error");
            this.entries = Objects.requireNonNull(entries, "entries");
        }

        public ApiError error() {
            return this.error;
        }

        public Collection<ConfigEntry> entries() {
            return this.entries;
        }
    }
}

