/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.HeartbeatResponse;

public class HeartbeatRequest
extends AbstractRequest {
    private static final Schema HEARTBEAT_REQUEST_V0;
    private static final Schema HEARTBEAT_REQUEST_V1;
    private static final Schema HEARTBEAT_REQUEST_V2;
    private final String groupId;
    private final int groupGenerationId;
    private final String memberId;

    public static Schema[] schemaVersions() {
        return new Schema[]{HEARTBEAT_REQUEST_V0, HEARTBEAT_REQUEST_V1, HEARTBEAT_REQUEST_V2};
    }

    private HeartbeatRequest(String groupId, int groupGenerationId, String memberId, short version) {
        super(ApiKeys.HEARTBEAT, version);
        this.groupId = groupId;
        this.groupGenerationId = groupGenerationId;
        this.memberId = memberId;
    }

    public HeartbeatRequest(Struct struct, short version) {
        super(ApiKeys.HEARTBEAT, version);
        this.groupId = struct.get(CommonFields.GROUP_ID);
        this.groupGenerationId = struct.get(CommonFields.GENERATION_ID);
        this.memberId = struct.get(CommonFields.MEMBER_ID);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new HeartbeatResponse(Errors.forException(e));
            }
            case 1: 
            case 2: {
                return new HeartbeatResponse(throttleTimeMs, Errors.forException(e));
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.HEARTBEAT.latestVersion()));
    }

    public String groupId() {
        return this.groupId;
    }

    public int groupGenerationId() {
        return this.groupGenerationId;
    }

    public String memberId() {
        return this.memberId;
    }

    public static HeartbeatRequest parse(ByteBuffer buffer, short version) {
        return new HeartbeatRequest(ApiKeys.HEARTBEAT.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.HEARTBEAT.requestSchema(this.version()));
        struct.set(CommonFields.GROUP_ID, this.groupId);
        struct.set(CommonFields.GENERATION_ID, this.groupGenerationId);
        struct.set(CommonFields.MEMBER_ID, this.memberId);
        return struct;
    }

    static {
        HEARTBEAT_REQUEST_V2 = HEARTBEAT_REQUEST_V1 = (HEARTBEAT_REQUEST_V0 = new Schema(CommonFields.GROUP_ID, CommonFields.GENERATION_ID, CommonFields.MEMBER_ID));
    }

    public static class Builder
    extends AbstractRequest.Builder<HeartbeatRequest> {
        private final String groupId;
        private final int groupGenerationId;
        private final String memberId;

        public Builder(String groupId, int groupGenerationId, String memberId) {
            super(ApiKeys.HEARTBEAT);
            this.groupId = groupId;
            this.groupGenerationId = groupGenerationId;
            this.memberId = memberId;
        }

        @Override
        public HeartbeatRequest build(short version) {
            return new HeartbeatRequest(this.groupId, this.groupGenerationId, this.memberId, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=HeartbeatRequest").append(", groupId=").append(this.groupId).append(", groupGenerationId=").append(this.groupGenerationId).append(", memberId=").append(this.memberId).append(")");
            return bld.toString();
        }
    }
}

