/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Node;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.BasePartitionState;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.CollectionUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;

public class LeaderAndIsrRequest
extends AbstractControlRequest {
    private static final Field.ComplexArray TOPIC_STATES = new Field.ComplexArray("topic_states", "Topic states");
    private static final Field.ComplexArray PARTITION_STATES = new Field.ComplexArray("partition_states", "Partition states");
    private static final Field.ComplexArray LIVE_LEADERS = new Field.ComplexArray("live_leaders", "Live leaders");
    private static final Field.Int32 LEADER = new Field.Int32("leader", "The broker id for the leader.");
    private static final Field.Int32 LEADER_EPOCH = new Field.Int32("leader_epoch", "The leader epoch.");
    private static final Field.Array ISR = new Field.Array("isr", Type.INT32, "The in sync replica ids.");
    private static final Field.Int32 ZK_VERSION = new Field.Int32("zk_version", "The ZK version.");
    private static final Field.Array REPLICAS = new Field.Array("replicas", Type.INT32, "The replica ids.");
    private static final Field.Bool IS_NEW = new Field.Bool("is_new", "Whether the replica should have existed on the broker or not");
    private static final Field.Int32 END_POINT_ID = new Field.Int32("id", "The broker id");
    private static final Field.Str HOST = new Field.Str("host", "The hostname of the broker.");
    private static final Field.Int32 PORT = new Field.Int32("port", "The port on which the broker accepts requests.");
    private static final Field PARTITION_STATES_V0 = PARTITION_STATES.withFields(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID, CONTROLLER_EPOCH, LEADER, LEADER_EPOCH, ISR, ZK_VERSION, REPLICAS);
    private static final Field PARTITION_STATES_V1 = PARTITION_STATES.withFields(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID, CONTROLLER_EPOCH, LEADER, LEADER_EPOCH, ISR, ZK_VERSION, REPLICAS, IS_NEW);
    private static final Field PARTITION_STATES_V2 = PARTITION_STATES.withFields(CommonFields.PARTITION_ID, CONTROLLER_EPOCH, LEADER, LEADER_EPOCH, ISR, ZK_VERSION, REPLICAS, IS_NEW);
    private static final Field TOPIC_STATES_V2 = TOPIC_STATES.withFields(CommonFields.TOPIC_NAME, PARTITION_STATES_V2);
    private static final Field LIVE_LEADERS_V0 = LIVE_LEADERS.withFields(END_POINT_ID, HOST, PORT);
    private static final Schema LEADER_AND_ISR_REQUEST_V0 = new Schema(CONTROLLER_ID, CONTROLLER_EPOCH, PARTITION_STATES_V0, LIVE_LEADERS_V0);
    private static final Schema LEADER_AND_ISR_REQUEST_V1 = new Schema(CONTROLLER_ID, CONTROLLER_EPOCH, PARTITION_STATES_V1, LIVE_LEADERS_V0);
    private static final Schema LEADER_AND_ISR_REQUEST_V2 = new Schema(CONTROLLER_ID, CONTROLLER_EPOCH, BROKER_EPOCH, TOPIC_STATES_V2, LIVE_LEADERS_V0);
    private final Map<TopicPartition, PartitionState> partitionStates;
    private final Set<Node> liveLeaders;

    public static Schema[] schemaVersions() {
        return new Schema[]{LEADER_AND_ISR_REQUEST_V0, LEADER_AND_ISR_REQUEST_V1, LEADER_AND_ISR_REQUEST_V2};
    }

    private LeaderAndIsrRequest(int controllerId, int controllerEpoch, long brokerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Node> liveLeaders, short version) {
        super(ApiKeys.LEADER_AND_ISR, version, controllerId, controllerEpoch, brokerEpoch);
        this.partitionStates = partitionStates;
        this.liveLeaders = liveLeaders;
    }

    public LeaderAndIsrRequest(Struct struct, short version) {
        super(ApiKeys.LEADER_AND_ISR, struct, version);
        String topic;
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        if (struct.hasField(TOPIC_STATES)) {
            for (Object topicStatesDataObj : struct.get(TOPIC_STATES)) {
                Struct topicStatesData = (Struct)topicStatesDataObj;
                topic = topicStatesData.get(CommonFields.TOPIC_NAME);
                for (Object partitionStateDataObj : topicStatesData.get(PARTITION_STATES)) {
                    Struct partitionStateData = (Struct)partitionStateDataObj;
                    int partition = partitionStateData.get(CommonFields.PARTITION_ID);
                    PartitionState partitionState = new PartitionState(partitionStateData);
                    partitionStates.put(new TopicPartition(topic, partition), partitionState);
                }
            }
        } else {
            for (Object partitionStateDataObj : struct.get(PARTITION_STATES)) {
                Struct partitionStateData = (Struct)partitionStateDataObj;
                topic = partitionStateData.get(CommonFields.TOPIC_NAME);
                int partition = partitionStateData.get(CommonFields.PARTITION_ID);
                PartitionState partitionState = new PartitionState(partitionStateData);
                partitionStates.put(new TopicPartition(topic, partition), partitionState);
            }
        }
        HashSet<Node> leaders = new HashSet<Node>();
        for (Object leadersDataObj : struct.get(LIVE_LEADERS)) {
            Struct leadersData = (Struct)leadersDataObj;
            int id = leadersData.get(END_POINT_ID);
            String host = leadersData.get(HOST);
            int port = leadersData.get(PORT);
            leaders.add(new Node(id, host, port));
        }
        this.partitionStates = partitionStates;
        this.liveLeaders = leaders;
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.LEADER_AND_ISR.requestSchema(version));
        struct.set(CONTROLLER_ID, this.controllerId);
        struct.set(CONTROLLER_EPOCH, this.controllerEpoch);
        struct.setIfExists(BROKER_EPOCH, (Object)this.brokerEpoch);
        if (struct.hasField(TOPIC_STATES)) {
            Map<String, Map<Integer, PartitionState>> topicStates = CollectionUtils.groupPartitionDataByTopic(this.partitionStates);
            ArrayList<Struct> topicStatesData = new ArrayList<Struct>(topicStates.size());
            for (Map.Entry<String, Map<Integer, PartitionState>> entry : topicStates.entrySet()) {
                Struct topicStateData = struct.instance(TOPIC_STATES);
                topicStateData.set(CommonFields.TOPIC_NAME, entry.getKey());
                Map<Integer, PartitionState> partitionMap = entry.getValue();
                ArrayList<Struct> partitionStatesData = new ArrayList<Struct>(partitionMap.size());
                for (Map.Entry<Integer, PartitionState> partitionEntry : partitionMap.entrySet()) {
                    Struct partitionStateData = topicStateData.instance(PARTITION_STATES);
                    partitionStateData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                    partitionEntry.getValue().setStruct(partitionStateData);
                    partitionStatesData.add(partitionStateData);
                }
                topicStateData.set(PARTITION_STATES, partitionStatesData.toArray());
                topicStatesData.add(topicStateData);
            }
            struct.set(TOPIC_STATES, topicStatesData.toArray());
        } else {
            ArrayList<Struct> partitionStatesData = new ArrayList<Struct>(this.partitionStates.size());
            for (Map.Entry<TopicPartition, PartitionState> entry : this.partitionStates.entrySet()) {
                Struct partitionStateData = struct.instance(PARTITION_STATES);
                TopicPartition topicPartition = entry.getKey();
                partitionStateData.set(CommonFields.TOPIC_NAME, topicPartition.topic());
                partitionStateData.set(CommonFields.PARTITION_ID, topicPartition.partition());
                entry.getValue().setStruct(partitionStateData);
                partitionStatesData.add(partitionStateData);
            }
            struct.set(PARTITION_STATES, partitionStatesData.toArray());
        }
        ArrayList<Struct> leadersData = new ArrayList<Struct>(this.liveLeaders.size());
        for (Node leader : this.liveLeaders) {
            Struct leaderData = struct.instance(LIVE_LEADERS);
            leaderData.set(END_POINT_ID, leader.id());
            leaderData.set(HOST, leader.host());
            leaderData.set(PORT, leader.port());
            leadersData.add(leaderData);
        }
        struct.set(LIVE_LEADERS, leadersData.toArray());
        return struct;
    }

    @Override
    public LeaderAndIsrResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<TopicPartition, Errors> responses = new HashMap<TopicPartition, Errors>(this.partitionStates.size());
        for (TopicPartition partition : this.partitionStates.keySet()) {
            responses.put(partition, error);
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                return new LeaderAndIsrResponse(error, responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.LEADER_AND_ISR.latestVersion()));
    }

    @Override
    public int controllerId() {
        return this.controllerId;
    }

    @Override
    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public Map<TopicPartition, PartitionState> partitionStates() {
        return this.partitionStates;
    }

    public Set<Node> liveLeaders() {
        return this.liveLeaders;
    }

    public static LeaderAndIsrRequest parse(ByteBuffer buffer, short version) {
        return new LeaderAndIsrRequest(ApiKeys.LEADER_AND_ISR.parseRequest(version, buffer), version);
    }

    public static final class PartitionState {
        public final BasePartitionState basePartitionState;
        public final boolean isNew;

        public PartitionState(int controllerEpoch, int leader, int leaderEpoch, List<Integer> isr, int zkVersion, List<Integer> replicas, boolean isNew) {
            this.basePartitionState = new BasePartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas);
            this.isNew = isNew;
        }

        private PartitionState(Struct struct) {
            int controllerEpoch = struct.get(AbstractControlRequest.CONTROLLER_EPOCH);
            int leader = struct.get(LEADER);
            int leaderEpoch = struct.get(LEADER_EPOCH);
            Object[] isrArray = struct.get(ISR);
            ArrayList<Integer> isr = new ArrayList<Integer>(isrArray.length);
            for (Object r : isrArray) {
                isr.add((Integer)r);
            }
            int zkVersion = struct.get(ZK_VERSION);
            Object[] replicasArray = struct.get(REPLICAS);
            ArrayList<Integer> replicas = new ArrayList<Integer>(replicasArray.length);
            for (Object r : replicasArray) {
                replicas.add((Integer)r);
            }
            this.basePartitionState = new BasePartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas);
            this.isNew = struct.getOrElse(IS_NEW, false);
        }

        public String toString() {
            return "PartitionState(controllerEpoch=" + this.basePartitionState.controllerEpoch + ", leader=" + this.basePartitionState.leader + ", leaderEpoch=" + this.basePartitionState.leaderEpoch + ", isr=" + Utils.join(this.basePartitionState.isr, ",") + ", zkVersion=" + this.basePartitionState.zkVersion + ", replicas=" + Utils.join(this.basePartitionState.replicas, ",") + ", isNew=" + this.isNew + ")";
        }

        private void setStruct(Struct struct) {
            struct.set(AbstractControlRequest.CONTROLLER_EPOCH, this.basePartitionState.controllerEpoch);
            struct.set(LEADER, this.basePartitionState.leader);
            struct.set(LEADER_EPOCH, this.basePartitionState.leaderEpoch);
            struct.set(ISR, this.basePartitionState.isr.toArray());
            struct.set(ZK_VERSION, this.basePartitionState.zkVersion);
            struct.set(REPLICAS, this.basePartitionState.replicas.toArray());
            struct.setIfExists(IS_NEW, (Object)this.isNew);
        }
    }

    public static class Builder
    extends AbstractControlRequest.Builder<LeaderAndIsrRequest> {
        private final Map<TopicPartition, PartitionState> partitionStates;
        private final Set<Node> liveLeaders;

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Node> liveLeaders) {
            super(ApiKeys.LEADER_AND_ISR, version, controllerId, controllerEpoch, brokerEpoch);
            this.partitionStates = partitionStates;
            this.liveLeaders = liveLeaders;
        }

        @Override
        public LeaderAndIsrRequest build(short version) {
            return new LeaderAndIsrRequest(this.controllerId, this.controllerEpoch, this.brokerEpoch, this.partitionStates, this.liveLeaders, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=LeaderAndIsRequest").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", brokerEpoch=").append(this.brokerEpoch).append(", partitionStates=").append(this.partitionStates).append(", liveLeaders=(").append(Utils.join(this.liveLeaders, ", ")).append(")").append(")");
            return bld.toString();
        }
    }
}

