/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class TxnOffsetCommitResponse
extends AbstractResponse {
    private static final Field.ComplexArray TOPICS = new Field.ComplexArray("topics", "Responses by topic for committed offsets");
    private static final Field.ComplexArray PARTITIONS = new Field.ComplexArray("partitions", "Responses by partition for committed offsets");
    private static final Field PARTITIONS_V0 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE);
    private static final Field TOPICS_V0 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V0);
    private static final Schema TXN_OFFSET_COMMIT_RESPONSE_V0;
    private static final Schema TXN_OFFSET_COMMIT_RESPONSE_V1;
    private static final Schema TXN_OFFSET_COMMIT_RESPONSE_V2;
    private final Map<TopicPartition, Errors> errors;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{TXN_OFFSET_COMMIT_RESPONSE_V0, TXN_OFFSET_COMMIT_RESPONSE_V1, TXN_OFFSET_COMMIT_RESPONSE_V2};
    }

    public TxnOffsetCommitResponse(int throttleTimeMs, Map<TopicPartition, Errors> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public TxnOffsetCommitResponse(Struct struct) {
        Object[] topicPartitionsArray;
        this.throttleTimeMs = struct.get(CommonFields.THROTTLE_TIME_MS);
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        for (Object topicPartitionObj : topicPartitionsArray = struct.get(TOPICS)) {
            Struct topicPartitionStruct = (Struct)topicPartitionObj;
            String topic = topicPartitionStruct.get(CommonFields.TOPIC_NAME);
            for (Object partitionObj : topicPartitionStruct.get(PARTITIONS)) {
                Struct partitionStruct = (Struct)partitionObj;
                Integer partition = partitionStruct.get(CommonFields.PARTITION_ID);
                Errors error = Errors.forCode(partitionStruct.get(CommonFields.ERROR_CODE));
                errors.put(new TopicPartition(topic, partition), error);
            }
        }
        this.errors = errors;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.TXN_OFFSET_COMMIT.responseSchema(version));
        struct.set(CommonFields.THROTTLE_TIME_MS, this.throttleTimeMs);
        Map<String, Map<Integer, Errors>> mappedPartitions = CollectionUtils.groupPartitionDataByTopic(this.errors);
        Object[] partitionsArray = new Object[mappedPartitions.size()];
        int i = 0;
        for (Map.Entry<String, Map<Integer, Errors>> topicAndPartitions : mappedPartitions.entrySet()) {
            Struct topicPartitionsStruct = struct.instance(TOPICS);
            topicPartitionsStruct.set(CommonFields.TOPIC_NAME, topicAndPartitions.getKey());
            Map<Integer, Errors> partitionAndErrors = topicAndPartitions.getValue();
            Object[] partitionAndErrorsArray = new Object[partitionAndErrors.size()];
            int j = 0;
            for (Map.Entry<Integer, Errors> partitionAndError : partitionAndErrors.entrySet()) {
                Struct partitionAndErrorStruct = topicPartitionsStruct.instance(PARTITIONS);
                partitionAndErrorStruct.set(CommonFields.PARTITION_ID, partitionAndError.getKey());
                partitionAndErrorStruct.set(CommonFields.ERROR_CODE, partitionAndError.getValue().code());
                partitionAndErrorsArray[j++] = partitionAndErrorStruct;
            }
            topicPartitionsStruct.set(PARTITIONS, partitionAndErrorsArray);
            partitionsArray[i++] = topicPartitionsStruct;
        }
        struct.set(TOPICS, partitionsArray);
        return struct;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<TopicPartition, Errors> errors() {
        return this.errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.errors);
    }

    public static TxnOffsetCommitResponse parse(ByteBuffer buffer, short version) {
        return new TxnOffsetCommitResponse(ApiKeys.TXN_OFFSET_COMMIT.parseResponse(version, buffer));
    }

    public String toString() {
        return "TxnOffsetCommitResponse(errors=" + this.errors + ", throttleTimeMs=" + this.throttleTimeMs + ')';
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }

    static {
        TXN_OFFSET_COMMIT_RESPONSE_V2 = TXN_OFFSET_COMMIT_RESPONSE_V1 = (TXN_OFFSET_COMMIT_RESPONSE_V0 = new Schema(CommonFields.THROTTLE_TIME_MS, TOPICS_V0));
    }
}

