/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.CreateTopicsRequest;

public class NewTopic {
    private final String name;
    private final int numPartitions;
    private final short replicationFactor;
    private final Map<Integer, List<Integer>> replicasAssignments;
    private Map<String, String> configs = null;

    public NewTopic(String name, int numPartitions, short replicationFactor) {
        this.name = name;
        this.numPartitions = numPartitions;
        this.replicationFactor = replicationFactor;
        this.replicasAssignments = null;
    }

    public NewTopic(String name, Map<Integer, List<Integer>> replicasAssignments) {
        this.name = name;
        this.numPartitions = -1;
        this.replicationFactor = (short)-1;
        this.replicasAssignments = Collections.unmodifiableMap(replicasAssignments);
    }

    public String name() {
        return this.name;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public short replicationFactor() {
        return this.replicationFactor;
    }

    public Map<Integer, List<Integer>> replicasAssignments() {
        return this.replicasAssignments;
    }

    public NewTopic configs(Map<String, String> configs) {
        this.configs = configs;
        return this;
    }

    public Map<String, String> configs() {
        return this.configs;
    }

    CreateTopicsRequest.TopicDetails convertToTopicDetails() {
        if (this.replicasAssignments != null) {
            if (this.configs != null) {
                return new CreateTopicsRequest.TopicDetails(this.replicasAssignments, this.configs);
            }
            return new CreateTopicsRequest.TopicDetails(this.replicasAssignments);
        }
        if (this.configs != null) {
            return new CreateTopicsRequest.TopicDetails(this.numPartitions, this.replicationFactor, this.configs);
        }
        return new CreateTopicsRequest.TopicDetails(this.numPartitions, this.replicationFactor);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("(name=").append(this.name).append(", numPartitions=").append(this.numPartitions).append(", replicationFactor=").append(this.replicationFactor).append(", replicasAssignments=").append(this.replicasAssignments).append(", configs=").append(this.configs).append(")");
        return bld.toString();
    }
}

