/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;

public class AddOffsetsToTxnRequestData
implements ApiMessage {
    private String transactionalId;
    private long producerId;
    private short producerEpoch;
    private String groupId;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public AddOffsetsToTxnRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public AddOffsetsToTxnRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public AddOffsetsToTxnRequestData() {
        this.transactionalId = "";
        this.producerId = 0L;
        this.producerEpoch = 0;
        this.groupId = "";
    }

    @Override
    public short apiKey() {
        return 25;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.transactionalId = readable.readNullableString();
        this.producerId = readable.readLong();
        this.producerEpoch = readable.readShort();
        this.groupId = readable.readNullableString();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeString(this.transactionalId);
        writable.writeLong(this.producerId);
        writable.writeShort(this.producerEpoch);
        writable.writeString(this.groupId);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.transactionalId = struct.getString("transactional_id");
        this.producerId = struct.getLong("producer_id");
        this.producerEpoch = struct.getShort("producer_epoch");
        this.groupId = struct.getString("group_id");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("transactional_id", (Object)this.transactionalId);
        struct.set("producer_id", (Object)this.producerId);
        struct.set("producer_epoch", (Object)this.producerEpoch);
        struct.set("group_id", (Object)this.groupId);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.transactionalId);
        size += 8;
        size += 2;
        size += 2;
        return size += MessageUtil.serializedUtf8Length(this.groupId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddOffsetsToTxnRequestData)) {
            return false;
        }
        AddOffsetsToTxnRequestData other = (AddOffsetsToTxnRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.producerId != other.producerId) {
            return false;
        }
        if (this.producerEpoch != other.producerEpoch) {
            return false;
        }
        return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        return hashCode;
    }

    public String toString() {
        return "AddOffsetsToTxnRequestData(transactionalId='" + this.transactionalId + "', producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", groupId='" + this.groupId + "')";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public String groupId() {
        return this.groupId;
    }

    public AddOffsetsToTxnRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public AddOffsetsToTxnRequestData setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public AddOffsetsToTxnRequestData setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    public AddOffsetsToTxnRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("transactional_id", Type.STRING, "The transactional id corresponding to the transaction."), new Field("producer_id", Type.INT64, "Current producer id in use by the transactional id."), new Field("producer_epoch", Type.INT16, "Current epoch associated with the producer id."), new Field("group_id", Type.STRING, "The unique group identifier."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

