/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;

public class ElectPreferredLeadersRequestData
implements ApiMessage {
    private List<TopicPartitions> topicPartitions = new ArrayList<TopicPartitions>();
    private int timeoutMs;
    public static final Schema SCHEMA_0 = new Schema(new Field("topic_partitions", ArrayOf.nullable(TopicPartitions.SCHEMA_0), "The topic partitions to elect the preferred leader of."), new Field("timeout_ms", Type.INT32, "The time in ms to wait for the election to complete."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public ElectPreferredLeadersRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public ElectPreferredLeadersRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public ElectPreferredLeadersRequestData() {
        this.timeoutMs = 60000;
    }

    @Override
    public short apiKey() {
        return 43;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topicPartitions.clear();
        } else {
            this.topicPartitions.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topicPartitions.add(new TopicPartitions(readable, version));
            }
        }
        this.timeoutMs = readable.readInt();
    }

    @Override
    public void write(Writable writable, short version) {
        if (this.topicPartitions == null) {
            writable.writeInt(-1);
        } else {
            writable.writeInt(this.topicPartitions.size());
            for (TopicPartitions element : this.topicPartitions) {
                element.write(writable, version);
            }
        }
        writable.writeInt(this.timeoutMs);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("topic_partitions");
        if (nestedObjects == null) {
            this.topicPartitions = null;
        } else {
            this.topicPartitions = new ArrayList<TopicPartitions>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.topicPartitions.add(new TopicPartitions((Struct)nestedObject, version));
            }
        }
        this.timeoutMs = struct.getInt("timeout_ms");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (this.topicPartitions == null) {
            struct.set("topic_partitions", null);
        } else {
            Struct[] nestedObjects = new Struct[this.topicPartitions.size()];
            int i = 0;
            for (TopicPartitions element : this.topicPartitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("topic_partitions", (Object)nestedObjects);
        }
        struct.set("timeout_ms", (Object)this.timeoutMs);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        if (this.topicPartitions == null) {
            size += 4;
        } else {
            size += 4;
            for (TopicPartitions element : this.topicPartitions) {
                size += element.size(version);
            }
        }
        return size += 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElectPreferredLeadersRequestData)) {
            return false;
        }
        ElectPreferredLeadersRequestData other = (ElectPreferredLeadersRequestData)obj;
        if (this.topicPartitions == null ? other.topicPartitions != null : !this.topicPartitions.equals(other.topicPartitions)) {
            return false;
        }
        return this.timeoutMs == other.timeoutMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topicPartitions == null ? 0 : this.topicPartitions.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    public String toString() {
        return "ElectPreferredLeadersRequestData(topicPartitions=" + MessageUtil.deepToString(this.topicPartitions.iterator()) + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<TopicPartitions> topicPartitions() {
        return this.topicPartitions;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public ElectPreferredLeadersRequestData setTopicPartitions(List<TopicPartitions> v) {
        this.topicPartitions = v;
        return this;
    }

    public ElectPreferredLeadersRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public static class TopicPartitions
    implements Message {
        private String topic;
        private List<Integer> partitionId;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.STRING, "The name of a topic."), new Field("partition_id", new ArrayOf(Type.INT32), "The partitions of this topic whose preferred leader should be elected"));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public TopicPartitions(Readable readable, short version) {
            this.partitionId = new ArrayList<Integer>();
            this.read(readable, version);
        }

        public TopicPartitions(Struct struct, short version) {
            this.partitionId = new ArrayList<Integer>();
            this.fromStruct(struct, version);
        }

        public TopicPartitions() {
            this.topic = "";
            this.partitionId = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable readable, short version) {
            this.topic = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitionId.clear();
            } else {
                this.partitionId.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitionId.add(readable.readInt());
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.topic);
            writable.writeInt(this.partitionId.size());
            for (Integer element : this.partitionId) {
                writable.writeInt(element);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.topic = struct.getString("topic");
            Object[] nestedObjects = struct.getArray("partition_id");
            this.partitionId = new ArrayList<Integer>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitionId.add((Integer)nestedObject);
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("topic", (Object)this.topic);
            Integer[] nestedObjects = new Integer[this.partitionId.size()];
            int i = 0;
            for (Integer element : this.partitionId) {
                nestedObjects[i++] = element;
            }
            struct.set("partition_id", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.topic);
            size += 4;
            return size += this.partitionId.size() * 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartitions)) {
                return false;
            }
            TopicPartitions other = (TopicPartitions)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            return !(this.partitionId == null ? other.partitionId != null : !this.partitionId.equals(other.partitionId));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitionId == null ? 0 : this.partitionId.hashCode());
            return hashCode;
        }

        public String toString() {
            return "TopicPartitions(topic='" + this.topic + "', partitionId=" + MessageUtil.deepToString(this.partitionId.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<Integer> partitionId() {
            return this.partitionId;
        }

        public TopicPartitions setTopic(String v) {
            this.topic = v;
            return this;
        }

        public TopicPartitions setPartitionId(List<Integer> v) {
            this.partitionId = v;
            return this;
        }
    }
}

