/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.util.Arrays;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Bytes;

public class RenewDelegationTokenRequestData
implements ApiMessage {
    private byte[] hmac;
    private long renewPeriodMs;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public RenewDelegationTokenRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public RenewDelegationTokenRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public RenewDelegationTokenRequestData() {
        this.hmac = Bytes.EMPTY;
        this.renewPeriodMs = 0L;
    }

    @Override
    public short apiKey() {
        return 39;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.hmac = readable.readNullableBytes();
        this.renewPeriodMs = readable.readLong();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeBytes(this.hmac);
        writable.writeLong(this.renewPeriodMs);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.hmac = struct.getByteArray("hmac");
        this.renewPeriodMs = struct.getLong("renew_period_ms");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.setByteArray("hmac", this.hmac);
        struct.set("renew_period_ms", (Object)this.renewPeriodMs);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        size += this.hmac.length;
        return size += 8;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RenewDelegationTokenRequestData)) {
            return false;
        }
        RenewDelegationTokenRequestData other = (RenewDelegationTokenRequestData)obj;
        if (!Arrays.equals(this.hmac, other.hmac)) {
            return false;
        }
        return this.renewPeriodMs == other.renewPeriodMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Arrays.hashCode(this.hmac);
        hashCode = 31 * hashCode + ((int)(this.renewPeriodMs >> 32) ^ (int)this.renewPeriodMs);
        return hashCode;
    }

    public String toString() {
        return "RenewDelegationTokenRequestData(hmac=" + Arrays.toString(this.hmac) + ", renewPeriodMs=" + this.renewPeriodMs + ")";
    }

    public byte[] hmac() {
        return this.hmac;
    }

    public long renewPeriodMs() {
        return this.renewPeriodMs;
    }

    public RenewDelegationTokenRequestData setHmac(byte[] v) {
        this.hmac = v;
        return this;
    }

    public RenewDelegationTokenRequestData setRenewPeriodMs(long v) {
        this.renewPeriodMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("hmac", Type.BYTES, "The HMAC of the delegation token to be renewed."), new Field("renew_period_ms", Type.INT64, "The renewal time period in milliseconds."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

