/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Cluster;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Node;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.PartitionInfo;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.InvalidMetadataException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.RequestUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;

public class MetadataResponse
extends AbstractResponse {
    public static final int NO_CONTROLLER_ID = -1;
    private static final Field.ComplexArray BROKERS = new Field.ComplexArray("brokers", "Host and port information for all brokers.");
    private static final Field.ComplexArray TOPIC_METADATA = new Field.ComplexArray("topic_metadata", "Metadata for requested topics");
    private static final Field.NullableStr CLUSTER_ID = new Field.NullableStr("cluster_id", "The cluster id that this broker belongs to.");
    private static final Field.Int32 CONTROLLER_ID = new Field.Int32("controller_id", "The broker id of the controller broker.");
    private static final Field.Int32 NODE_ID = new Field.Int32("node_id", "The broker id.");
    private static final Field.Str HOST = new Field.Str("host", "The hostname of the broker.");
    private static final Field.Int32 PORT = new Field.Int32("port", "The port on which the broker accepts requests.");
    private static final Field.NullableStr RACK = new Field.NullableStr("rack", "The rack of the broker.");
    private static final Field.ComplexArray PARTITION_METADATA = new Field.ComplexArray("partition_metadata", "Metadata for each partition of the topic.");
    private static final Field.Bool IS_INTERNAL = new Field.Bool("is_internal", "Indicates if the topic is considered a Kafka internal topic");
    private static final Field.Int32 LEADER = new Field.Int32("leader", "The id of the broker acting as leader for this partition.");
    private static final Field.Array REPLICAS = new Field.Array("replicas", Type.INT32, "The set of all nodes that host this partition.");
    private static final Field.Array ISR = new Field.Array("isr", Type.INT32, "The set of nodes that are in sync with the leader for this partition.");
    private static final Field.Array OFFLINE_REPLICAS = new Field.Array("offline_replicas", Type.INT32, "The set of offline replicas of this partition.");
    private static final Field METADATA_BROKER_V0 = BROKERS.withFields(NODE_ID, HOST, PORT);
    private static final Field PARTITION_METADATA_V0 = PARTITION_METADATA.withFields(CommonFields.ERROR_CODE, CommonFields.PARTITION_ID, LEADER, REPLICAS, ISR);
    private static final Field TOPIC_METADATA_V0 = TOPIC_METADATA.withFields(CommonFields.ERROR_CODE, CommonFields.TOPIC_NAME, PARTITION_METADATA_V0);
    private static final Schema METADATA_RESPONSE_V0 = new Schema(METADATA_BROKER_V0, TOPIC_METADATA_V0);
    private static final Field METADATA_BROKER_V1 = BROKERS.withFields(NODE_ID, HOST, PORT, RACK);
    private static final Field TOPIC_METADATA_V1 = TOPIC_METADATA.withFields(CommonFields.ERROR_CODE, CommonFields.TOPIC_NAME, IS_INTERNAL, PARTITION_METADATA_V0);
    private static final Schema METADATA_RESPONSE_V1 = new Schema(METADATA_BROKER_V1, CONTROLLER_ID, TOPIC_METADATA_V1);
    private static final Schema METADATA_RESPONSE_V2 = new Schema(METADATA_BROKER_V1, CLUSTER_ID, CONTROLLER_ID, TOPIC_METADATA_V1);
    private static final Schema METADATA_RESPONSE_V3;
    private static final Schema METADATA_RESPONSE_V4;
    private static final Field PARTITION_METADATA_V5;
    private static final Field TOPIC_METADATA_V5;
    private static final Schema METADATA_RESPONSE_V5;
    private static final Schema METADATA_RESPONSE_V6;
    private static final Field PARTITION_METADATA_V7;
    private static final Field TOPIC_METADATA_V7;
    private static final Schema METADATA_RESPONSE_V7;
    private final int throttleTimeMs;
    private final Collection<Node> brokers;
    private final Node controller;
    private final List<TopicMetadata> topicMetadata;
    private final String clusterId;

    public static Schema[] schemaVersions() {
        return new Schema[]{METADATA_RESPONSE_V0, METADATA_RESPONSE_V1, METADATA_RESPONSE_V2, METADATA_RESPONSE_V3, METADATA_RESPONSE_V4, METADATA_RESPONSE_V5, METADATA_RESPONSE_V6, METADATA_RESPONSE_V7};
    }

    public MetadataResponse(List<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadata) {
        this(0, brokers, clusterId, controllerId, topicMetadata);
    }

    public MetadataResponse(int throttleTimeMs, List<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadata) {
        this.throttleTimeMs = throttleTimeMs;
        this.brokers = brokers;
        this.controller = this.getControllerNode(controllerId, brokers);
        this.topicMetadata = topicMetadata;
        this.clusterId = clusterId;
    }

    public MetadataResponse(Struct struct) {
        Object[] topicInfos;
        Object[] brokerStructs;
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        HashMap<Integer, Node> brokers = new HashMap<Integer, Node>();
        for (Object brokerStruct : brokerStructs = struct.get(BROKERS)) {
            Struct broker = (Struct)brokerStruct;
            int nodeId = broker.get(NODE_ID);
            String host = broker.get(HOST);
            int port = broker.get(PORT);
            String rack = broker.getOrElse(RACK, null);
            brokers.put(nodeId, new Node(nodeId, host, port, rack));
        }
        int controllerId = struct.getOrElse(CONTROLLER_ID, -1);
        this.clusterId = struct.getOrElse(CLUSTER_ID, null);
        ArrayList<TopicMetadata> topicMetadata = new ArrayList<TopicMetadata>();
        for (Object topicInfoObj : topicInfos = struct.get(TOPIC_METADATA)) {
            Object[] partitionInfos;
            Struct topicInfo = (Struct)topicInfoObj;
            Errors topicError = Errors.forCode(topicInfo.get(CommonFields.ERROR_CODE));
            String topic = topicInfo.get(CommonFields.TOPIC_NAME);
            boolean isInternal = topicInfo.getOrElse(IS_INTERNAL, false);
            ArrayList<PartitionMetadata> partitionMetadata = new ArrayList<PartitionMetadata>();
            for (Object partitionInfoObj : partitionInfos = topicInfo.get(PARTITION_METADATA)) {
                Struct partitionInfo = (Struct)partitionInfoObj;
                Errors partitionError = Errors.forCode(partitionInfo.get(CommonFields.ERROR_CODE));
                int partition = partitionInfo.get(CommonFields.PARTITION_ID);
                int leader = partitionInfo.get(LEADER);
                Optional<Integer> leaderEpoch = RequestUtils.getLeaderEpoch(partitionInfo, CommonFields.LEADER_EPOCH);
                Node leaderNode = leader == -1 ? null : (Node)brokers.get(leader);
                Object[] replicas = partitionInfo.get(REPLICAS);
                List<Node> replicaNodes = this.convertToNodes(brokers, replicas);
                Object[] isr = partitionInfo.get(ISR);
                List<Node> isrNodes = this.convertToNodes(brokers, isr);
                Object[] offlineReplicas = partitionInfo.getOrEmpty(OFFLINE_REPLICAS);
                List<Node> offlineNodes = this.convertToNodes(brokers, offlineReplicas);
                partitionMetadata.add(new PartitionMetadata(partitionError, partition, leaderNode, leaderEpoch, replicaNodes, isrNodes, offlineNodes));
            }
            topicMetadata.add(new TopicMetadata(topicError, topic, isInternal, partitionMetadata));
        }
        this.brokers = brokers.values();
        this.controller = this.getControllerNode(controllerId, brokers.values());
        this.topicMetadata = topicMetadata;
    }

    private List<Node> convertToNodes(Map<Integer, Node> brokers, Object[] brokerIds) {
        ArrayList<Node> nodes = new ArrayList<Node>(brokerIds.length);
        for (Object brokerId : brokerIds) {
            if (brokers.containsKey(brokerId)) {
                nodes.add(brokers.get(brokerId));
                continue;
            }
            nodes.add(new Node((Integer)brokerId, "", -1));
        }
        return nodes;
    }

    private Node getControllerNode(int controllerId, Collection<Node> brokers) {
        for (Node broker : brokers) {
            if (broker.id() != controllerId) continue;
            return broker;
        }
        return null;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<String, Errors> errors() {
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        for (TopicMetadata metadata : this.topicMetadata) {
            if (metadata.error == Errors.NONE) continue;
            errors.put(metadata.topic(), metadata.error);
        }
        return errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (TopicMetadata metadata : this.topicMetadata) {
            this.updateErrorCounts(errorCounts, metadata.error);
        }
        return errorCounts;
    }

    public Set<String> topicsByError(Errors error) {
        HashSet<String> errorTopics = new HashSet<String>();
        for (TopicMetadata metadata : this.topicMetadata) {
            if (metadata.error != error) continue;
            errorTopics.add(metadata.topic());
        }
        return errorTopics;
    }

    public Set<String> unavailableTopics() {
        HashSet<String> invalidMetadataTopics = new HashSet<String>();
        block0: for (TopicMetadata topicMetadata : this.topicMetadata) {
            if (topicMetadata.error.exception() instanceof InvalidMetadataException) {
                invalidMetadataTopics.add(topicMetadata.topic);
                continue;
            }
            for (PartitionMetadata partitionMetadata : topicMetadata.partitionMetadata) {
                if (!(partitionMetadata.error.exception() instanceof InvalidMetadataException)) continue;
                invalidMetadataTopics.add(topicMetadata.topic);
                continue block0;
            }
        }
        return invalidMetadataTopics;
    }

    public Cluster cluster() {
        HashSet<String> internalTopics = new HashSet<String>();
        ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
        for (TopicMetadata metadata : this.topicMetadata) {
            if (metadata.error != Errors.NONE) continue;
            if (metadata.isInternal) {
                internalTopics.add(metadata.topic);
            }
            for (PartitionMetadata partitionMetadata : metadata.partitionMetadata) {
                partitions.add(MetadataResponse.partitionMetaToInfo(metadata.topic, partitionMetadata));
            }
        }
        return new Cluster(this.clusterId, this.brokers, partitions, this.topicsByError(Errors.TOPIC_AUTHORIZATION_FAILED), this.topicsByError(Errors.INVALID_TOPIC_EXCEPTION), internalTopics, this.controller);
    }

    public static PartitionInfo partitionMetaToInfo(String topic, PartitionMetadata partitionMetadata) {
        return new PartitionInfo(topic, partitionMetadata.partition(), partitionMetadata.leader(), partitionMetadata.replicas().toArray(new Node[0]), partitionMetadata.isr().toArray(new Node[0]), partitionMetadata.offlineReplicas().toArray(new Node[0]));
    }

    public Collection<Node> brokers() {
        return this.brokers;
    }

    public Collection<TopicMetadata> topicMetadata() {
        return this.topicMetadata;
    }

    public Node controller() {
        return this.controller;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public static MetadataResponse parse(ByteBuffer buffer, short version) {
        return new MetadataResponse(ApiKeys.METADATA.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.METADATA.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        ArrayList<Struct> brokerArray = new ArrayList<Struct>();
        for (Node node : this.brokers) {
            Struct broker = struct.instance(BROKERS);
            broker.set(NODE_ID, node.id());
            broker.set(HOST, node.host());
            broker.set(PORT, node.port());
            broker.setIfExists(RACK, (Object)node.rack());
            brokerArray.add(broker);
        }
        struct.set(BROKERS, brokerArray.toArray());
        struct.setIfExists(CONTROLLER_ID, (Object)(this.controller == null ? -1 : this.controller.id()));
        struct.setIfExists(CLUSTER_ID, (Object)this.clusterId);
        ArrayList<Struct> topicMetadataArray = new ArrayList<Struct>(this.topicMetadata.size());
        for (TopicMetadata metadata : this.topicMetadata) {
            Struct topicData = struct.instance(TOPIC_METADATA);
            topicData.set(CommonFields.TOPIC_NAME, metadata.topic);
            topicData.set(CommonFields.ERROR_CODE, metadata.error.code());
            topicData.setIfExists(IS_INTERNAL, (Object)metadata.isInternal());
            ArrayList<Struct> partitionMetadataArray = new ArrayList<Struct>(metadata.partitionMetadata.size());
            for (PartitionMetadata partitionMetadata : metadata.partitionMetadata()) {
                Object node2;
                Struct partitionData = topicData.instance(PARTITION_METADATA);
                partitionData.set(CommonFields.ERROR_CODE, partitionMetadata.error.code());
                partitionData.set(CommonFields.PARTITION_ID, partitionMetadata.partition);
                partitionData.set(LEADER, partitionMetadata.leaderId());
                RequestUtils.setLeaderEpochIfExists(partitionData, CommonFields.LEADER_EPOCH, partitionMetadata.leaderEpoch);
                ArrayList<Integer> replicas = new ArrayList<Integer>(partitionMetadata.replicas.size());
                for (Object node2 : partitionMetadata.replicas) {
                    replicas.add(((Node)node2).id());
                }
                partitionData.set(REPLICAS, replicas.toArray());
                ArrayList<Integer> isr = new ArrayList<Integer>(partitionMetadata.isr.size());
                node2 = partitionMetadata.isr.iterator();
                while (node2.hasNext()) {
                    Node node3 = (Node)node2.next();
                    isr.add(node3.id());
                }
                partitionData.set(ISR, isr.toArray());
                if (partitionData.hasField(OFFLINE_REPLICAS)) {
                    ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(partitionMetadata.offlineReplicas.size());
                    for (Node node4 : partitionMetadata.offlineReplicas) {
                        offlineReplicas.add(node4.id());
                    }
                    partitionData.set(OFFLINE_REPLICAS, offlineReplicas.toArray());
                }
                partitionMetadataArray.add(partitionData);
            }
            topicData.set(PARTITION_METADATA, partitionMetadataArray.toArray());
            topicMetadataArray.add(topicData);
        }
        struct.set(TOPIC_METADATA, topicMetadataArray.toArray());
        return struct;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 6;
    }

    static {
        METADATA_RESPONSE_V4 = METADATA_RESPONSE_V3 = new Schema(CommonFields.THROTTLE_TIME_MS, METADATA_BROKER_V1, CLUSTER_ID, CONTROLLER_ID, TOPIC_METADATA_V1);
        PARTITION_METADATA_V5 = PARTITION_METADATA.withFields(CommonFields.ERROR_CODE, CommonFields.PARTITION_ID, LEADER, REPLICAS, ISR, OFFLINE_REPLICAS);
        TOPIC_METADATA_V5 = TOPIC_METADATA.withFields(CommonFields.ERROR_CODE, CommonFields.TOPIC_NAME, IS_INTERNAL, PARTITION_METADATA_V5);
        METADATA_RESPONSE_V6 = METADATA_RESPONSE_V5 = new Schema(CommonFields.THROTTLE_TIME_MS, METADATA_BROKER_V1, CLUSTER_ID, CONTROLLER_ID, TOPIC_METADATA_V5);
        PARTITION_METADATA_V7 = PARTITION_METADATA.withFields(CommonFields.ERROR_CODE, CommonFields.PARTITION_ID, LEADER, CommonFields.LEADER_EPOCH, REPLICAS, ISR, OFFLINE_REPLICAS);
        TOPIC_METADATA_V7 = TOPIC_METADATA.withFields(CommonFields.ERROR_CODE, CommonFields.TOPIC_NAME, IS_INTERNAL, PARTITION_METADATA_V7);
        METADATA_RESPONSE_V7 = new Schema(CommonFields.THROTTLE_TIME_MS, METADATA_BROKER_V1, CLUSTER_ID, CONTROLLER_ID, TOPIC_METADATA_V7);
    }

    public static class PartitionMetadata {
        private final Errors error;
        private final int partition;
        private final Node leader;
        private final Optional<Integer> leaderEpoch;
        private final List<Node> replicas;
        private final List<Node> isr;
        private final List<Node> offlineReplicas;

        public PartitionMetadata(Errors error, int partition, Node leader, Optional<Integer> leaderEpoch, List<Node> replicas, List<Node> isr, List<Node> offlineReplicas) {
            this.error = error;
            this.partition = partition;
            this.leader = leader;
            this.leaderEpoch = leaderEpoch;
            this.replicas = replicas;
            this.isr = isr;
            this.offlineReplicas = offlineReplicas;
        }

        public Errors error() {
            return this.error;
        }

        public int partition() {
            return this.partition;
        }

        public int leaderId() {
            return this.leader == null ? -1 : this.leader.id();
        }

        public Optional<Integer> leaderEpoch() {
            return this.leaderEpoch;
        }

        public Node leader() {
            return this.leader;
        }

        public List<Node> replicas() {
            return this.replicas;
        }

        public List<Node> isr() {
            return this.isr;
        }

        public List<Node> offlineReplicas() {
            return this.offlineReplicas;
        }

        public String toString() {
            return "(type=PartitionMetadata, error=" + (Object)((Object)this.error) + ", partition=" + this.partition + ", leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", replicas=" + Utils.join(this.replicas, ",") + ", isr=" + Utils.join(this.isr, ",") + ", offlineReplicas=" + Utils.join(this.offlineReplicas, ",") + ')';
        }
    }

    public static class TopicMetadata {
        private final Errors error;
        private final String topic;
        private final boolean isInternal;
        private final List<PartitionMetadata> partitionMetadata;

        public TopicMetadata(Errors error, String topic, boolean isInternal, List<PartitionMetadata> partitionMetadata) {
            this.error = error;
            this.topic = topic;
            this.isInternal = isInternal;
            this.partitionMetadata = partitionMetadata;
        }

        public Errors error() {
            return this.error;
        }

        public String topic() {
            return this.topic;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public List<PartitionMetadata> partitionMetadata() {
            return this.partitionMetadata;
        }

        public String toString() {
            return "(type=TopicMetadata, error=" + (Object)((Object)this.error) + ", topic=" + this.topic + ", isInternal=" + this.isInternal + ", partitionMetadata=" + this.partitionMetadata + ')';
        }
    }
}

