/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class ProduceResponse
extends AbstractResponse {
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String PARTITION_RESPONSES_KEY_NAME = "partition_responses";
    public static final long INVALID_OFFSET = -1L;
    private static final String BASE_OFFSET_KEY_NAME = "base_offset";
    private static final String LOG_APPEND_TIME_KEY_NAME = "log_append_time";
    private static final String LOG_START_OFFSET_KEY_NAME = "log_start_offset";
    private static final Field.Int64 LOG_START_OFFSET_FIELD = new Field.Int64("log_start_offset", "The start offset of the log at the time this produce response was created", -1L);
    private static final Schema PRODUCE_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field("partition_responses", new ArrayOf(new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field("base_offset", Type.INT64))))))));
    private static final Schema PRODUCE_RESPONSE_V1 = new Schema(new Field("responses", new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field("partition_responses", new ArrayOf(new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field("base_offset", Type.INT64))))))), CommonFields.THROTTLE_TIME_MS);
    private static final Schema PRODUCE_RESPONSE_V2;
    private static final Schema PRODUCE_RESPONSE_V3;
    private static final Schema PRODUCE_RESPONSE_V4;
    public static final Schema PRODUCE_RESPONSE_V5;
    private static final Schema PRODUCE_RESPONSE_V6;
    private static final Schema PRODUCE_RESPONSE_V7;
    private final Map<TopicPartition, PartitionResponse> responses;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{PRODUCE_RESPONSE_V0, PRODUCE_RESPONSE_V1, PRODUCE_RESPONSE_V2, PRODUCE_RESPONSE_V3, PRODUCE_RESPONSE_V4, PRODUCE_RESPONSE_V5, PRODUCE_RESPONSE_V6, PRODUCE_RESPONSE_V7};
    }

    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses) {
        this(responses, 0);
    }

    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses, int throttleTimeMs) {
        this.responses = responses;
        this.throttleTimeMs = throttleTimeMs;
    }

    public ProduceResponse(Struct struct) {
        this.responses = new HashMap<TopicPartition, PartitionResponse>();
        for (Object topicResponse : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicRespStruct = (Struct)topicResponse;
            String topic = topicRespStruct.get(CommonFields.TOPIC_NAME);
            for (Object partResponse : topicRespStruct.getArray(PARTITION_RESPONSES_KEY_NAME)) {
                Struct partRespStruct = (Struct)partResponse;
                int partition = partRespStruct.get(CommonFields.PARTITION_ID);
                Errors error = Errors.forCode(partRespStruct.get(CommonFields.ERROR_CODE));
                long offset = partRespStruct.getLong(BASE_OFFSET_KEY_NAME);
                long logAppendTime = partRespStruct.getLong(LOG_APPEND_TIME_KEY_NAME);
                long logStartOffset = partRespStruct.getOrElse(LOG_START_OFFSET_FIELD, -1L);
                TopicPartition tp = new TopicPartition(topic, partition);
                this.responses.put(tp, new PartitionResponse(error, offset, logAppendTime, logStartOffset));
            }
        }
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.PRODUCE.responseSchema(version));
        Map<String, Map<Integer, PartitionResponse>> responseByTopic = CollectionUtils.groupPartitionDataByTopic(this.responses);
        ArrayList<Struct> topicDatas = new ArrayList<Struct>(responseByTopic.size());
        for (Map.Entry<String, Map<Integer, PartitionResponse>> entry : responseByTopic.entrySet()) {
            Struct topicData = struct.instance(RESPONSES_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, entry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionResponse> partitionEntry : entry.getValue().entrySet()) {
                Struct partStruct;
                PartitionResponse part = partitionEntry.getValue();
                short errorCode = part.error.code();
                if (errorCode == Errors.KAFKA_STORAGE_ERROR.code() && version <= 3) {
                    errorCode = Errors.NOT_LEADER_FOR_PARTITION.code();
                }
                if ((partStruct = topicData.instance(PARTITION_RESPONSES_KEY_NAME).set(CommonFields.PARTITION_ID, partitionEntry.getKey()).set(CommonFields.ERROR_CODE, errorCode).set(BASE_OFFSET_KEY_NAME, (Object)part.baseOffset)).hasField(LOG_APPEND_TIME_KEY_NAME)) {
                    partStruct.set(LOG_APPEND_TIME_KEY_NAME, (Object)part.logAppendTime);
                }
                partStruct.setIfExists(LOG_START_OFFSET_FIELD, (Object)part.logStartOffset);
                partitionArray.add(partStruct);
            }
            topicData.set(PARTITION_RESPONSES_KEY_NAME, (Object)partitionArray.toArray());
            topicDatas.add(topicData);
        }
        struct.set(RESPONSES_KEY_NAME, (Object)topicDatas.toArray());
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        return struct;
    }

    public Map<TopicPartition, PartitionResponse> responses() {
        return this.responses;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (PartitionResponse response : this.responses.values()) {
            this.updateErrorCounts(errorCounts, response.error);
        }
        return errorCounts;
    }

    public static ProduceResponse parse(ByteBuffer buffer, short version) {
        return new ProduceResponse(ApiKeys.PRODUCE.responseSchema(version).read(buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 6;
    }

    static {
        PRODUCE_RESPONSE_V4 = PRODUCE_RESPONSE_V3 = (PRODUCE_RESPONSE_V2 = new Schema(new Field(RESPONSES_KEY_NAME, new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field(PARTITION_RESPONSES_KEY_NAME, new ArrayOf(new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field(BASE_OFFSET_KEY_NAME, Type.INT64), new Field(LOG_APPEND_TIME_KEY_NAME, Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1. If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."))))))), CommonFields.THROTTLE_TIME_MS));
        PRODUCE_RESPONSE_V7 = PRODUCE_RESPONSE_V6 = (PRODUCE_RESPONSE_V5 = new Schema(new Field(RESPONSES_KEY_NAME, new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field(PARTITION_RESPONSES_KEY_NAME, new ArrayOf(new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field(BASE_OFFSET_KEY_NAME, Type.INT64), new Field(LOG_APPEND_TIME_KEY_NAME, Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1. If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."), LOG_START_OFFSET_FIELD)))))), CommonFields.THROTTLE_TIME_MS));
    }

    public static final class PartitionResponse {
        public Errors error;
        public long baseOffset;
        public long logAppendTime;
        public long logStartOffset;

        public PartitionResponse(Errors error) {
            this(error, -1L, -1L, -1L);
        }

        public PartitionResponse(Errors error, long baseOffset, long logAppendTime, long logStartOffset) {
            this.error = error;
            this.baseOffset = baseOffset;
            this.logAppendTime = logAppendTime;
            this.logStartOffset = logStartOffset;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append('{');
            b.append("error: ");
            b.append((Object)this.error);
            b.append(",offset: ");
            b.append(this.baseOffset);
            b.append(",logAppendTime: ");
            b.append(this.logAppendTime);
            b.append(", logStartOffset: ");
            b.append(this.logStartOffset);
            b.append('}');
            return b.toString();
        }
    }
}

