/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class SaslAuthenticateResponse
extends AbstractResponse {
    private static final String SASL_AUTH_BYTES_KEY_NAME = "sasl_auth_bytes";
    private static final String SESSION_LIFETIME_MS = "session_lifetime_ms";
    private static final Schema SASL_AUTHENTICATE_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("sasl_auth_bytes", Type.BYTES, "SASL authentication bytes from server as defined by the SASL mechanism."));
    private static final Schema SASL_AUTHENTICATE_RESPONSE_V1 = new Schema(CommonFields.ERROR_CODE, CommonFields.ERROR_MESSAGE, new Field("sasl_auth_bytes", Type.BYTES, "SASL authentication bytes from server as defined by the SASL mechanism."), new Field("session_lifetime_ms", Type.INT64, "Number of milliseconds after which only re-authentication over the existing connection to create a new session can occur."));
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final ByteBuffer saslAuthBytes;
    private final Errors error;
    private final String errorMessage;
    private final long sessionLifetimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{SASL_AUTHENTICATE_RESPONSE_V0, SASL_AUTHENTICATE_RESPONSE_V1};
    }

    public SaslAuthenticateResponse(Errors error, String errorMessage) {
        this(error, errorMessage, EMPTY_BUFFER);
    }

    public SaslAuthenticateResponse(Errors error, String errorMessage, ByteBuffer saslAuthBytes) {
        this(error, errorMessage, saslAuthBytes, 0L);
    }

    public SaslAuthenticateResponse(Errors error, String errorMessage, ByteBuffer saslAuthBytes, long sessionLifetimeMs) {
        this.error = error;
        this.errorMessage = errorMessage;
        this.saslAuthBytes = saslAuthBytes;
        this.sessionLifetimeMs = sessionLifetimeMs;
    }

    public SaslAuthenticateResponse(Struct struct) {
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        this.errorMessage = struct.get(CommonFields.ERROR_MESSAGE);
        this.saslAuthBytes = struct.getBytes(SASL_AUTH_BYTES_KEY_NAME);
        this.sessionLifetimeMs = struct.hasField(SESSION_LIFETIME_MS) ? struct.getLong(SESSION_LIFETIME_MS) : 0L;
    }

    public Errors error() {
        return this.error;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public ByteBuffer saslAuthBytes() {
        return this.saslAuthBytes;
    }

    public long sessionLifetimeMs() {
        return this.sessionLifetimeMs;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.SASL_AUTHENTICATE.responseSchema(version));
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        struct.set(CommonFields.ERROR_MESSAGE, this.errorMessage);
        struct.set(SASL_AUTH_BYTES_KEY_NAME, (Object)this.saslAuthBytes);
        if (version > 0) {
            struct.set(SESSION_LIFETIME_MS, (Object)this.sessionLifetimeMs);
        }
        return struct;
    }

    public static SaslAuthenticateResponse parse(ByteBuffer buffer, short version) {
        return new SaslAuthenticateResponse(ApiKeys.SASL_AUTHENTICATE.parseResponse(version, buffer));
    }
}

