/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization;

import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.SerializationException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Deserializer;

public class ShortDeserializer
implements Deserializer<Short> {
    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public Short deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length != 2) {
            throw new SerializationException("Size of data received by ShortDeserializer is not 2");
        }
        short value = 0;
        for (byte b : data) {
            value = (short)(value << 8);
            value = (short)(value | b & 0xFF);
        }
        return value;
    }

    @Override
    public void close() {
    }
}

