/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashSet;

public class ImplicitLinkedHashMultiSet<E extends ImplicitLinkedHashSet.Element>
extends ImplicitLinkedHashSet<E> {
    public ImplicitLinkedHashMultiSet() {
        super(0);
    }

    public ImplicitLinkedHashMultiSet(int expectedNumElements) {
        super(expectedNumElements);
    }

    public ImplicitLinkedHashMultiSet(Iterator<E> iter) {
        super(iter);
    }

    @Override
    int addInternal(ImplicitLinkedHashSet.Element newElement, ImplicitLinkedHashSet.Element[] addElements) {
        int slot = this.slot(addElements, newElement);
        for (int seen = 0; seen < addElements.length; ++seen) {
            ImplicitLinkedHashSet.Element element = addElements[slot];
            if (element == null) {
                addElements[slot] = newElement;
                return slot;
            }
            if (element == newElement) {
                return -2;
            }
            slot = (slot + 1) % addElements.length;
        }
        throw new RuntimeException("Not enough hash table slots to add a new element.");
    }

    @Override
    int findElementToRemove(Object key) {
        if (key == null) {
            return -2;
        }
        int slot = this.slot(this.elements, key);
        int bestSlot = -2;
        for (int seen = 0; seen < this.elements.length; ++seen) {
            ImplicitLinkedHashSet.Element element = this.elements[slot];
            if (element == null) {
                return bestSlot;
            }
            if (key == element) {
                return slot;
            }
            if (key.equals(element)) {
                bestSlot = slot;
            }
            slot = (slot + 1) % this.elements.length;
        }
        return -2;
    }

    public final List<E> findAll(E key) {
        ImplicitLinkedHashSet.Element element;
        if (key == null) {
            return Collections.emptyList();
        }
        ArrayList<ImplicitLinkedHashSet.Element> results = new ArrayList<ImplicitLinkedHashSet.Element>();
        int slot = this.slot(this.elements, key);
        for (int seen = 0; seen < this.elements.length && (element = this.elements[slot]) != null; ++seen) {
            if (key.equals(element)) {
                ImplicitLinkedHashSet.Element result = this.elements[slot];
                results.add(result);
            }
            slot = (slot + 1) % this.elements.length;
        }
        return results;
    }
}

