/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.util;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DoubleValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DoubleValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.ShapeValues;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.ShapeValuesSource;
import org.locationtech.spatial4j.context.SpatialContext;

public class ShapeAreaValueSource
extends DoubleValuesSource {
    private final ShapeValuesSource shapeValueSource;
    private final SpatialContext ctx;
    private final boolean geoArea;
    private double multiplier;

    public ShapeAreaValueSource(ShapeValuesSource shapeValueSource, SpatialContext ctx, boolean geoArea, double multiplier) {
        this.shapeValueSource = shapeValueSource;
        this.ctx = ctx;
        this.geoArea = geoArea;
        this.multiplier = multiplier;
    }

    @Override
    public String toString() {
        return "area(" + this.shapeValueSource.toString() + ",geo=" + this.geoArea + ")";
    }

    @Override
    public DoubleValues getValues(LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        final ShapeValues shapeValues = this.shapeValueSource.getValues(readerContext);
        return DoubleValues.withDefault(new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return shapeValues.value().getArea(ShapeAreaValueSource.this.geoArea ? ShapeAreaValueSource.this.ctx : null) * ShapeAreaValueSource.this.multiplier;
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return shapeValues.advanceExact(doc);
            }
        }, 0.0);
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return this.shapeValueSource.isCacheable(ctx);
    }

    @Override
    public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeAreaValueSource that = (ShapeAreaValueSource)o;
        if (this.geoArea != that.geoArea) {
            return false;
        }
        return this.shapeValueSource.equals(that.shapeValueSource);
    }

    @Override
    public int hashCode() {
        int result = this.shapeValueSource.hashCode();
        result = 31 * result + (this.geoArea ? 1 : 0);
        return result;
    }
}

