/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.FailedNodeException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterName;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.Snapshot;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.SnapshotShardsService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;

public class TransportNodesSnapshotsStatus
extends TransportNodesAction<Request, NodesSnapshotStatus, NodeRequest, NodeSnapshotStatus> {
    public static final String ACTION_NAME = "cluster:admin/snapshot/status[nodes]";
    private final SnapshotShardsService snapshotShardsService;

    @Inject
    public TransportNodesSnapshotsStatus(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SnapshotShardsService snapshotShardsService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request::new, NodeRequest::new, "generic", NodeSnapshotStatus.class);
        this.snapshotShardsService = snapshotShardsService;
    }

    @Override
    protected boolean transportCompress() {
        return true;
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodeSnapshotStatus newNodeResponse() {
        return new NodeSnapshotStatus();
    }

    @Override
    protected NodesSnapshotStatus newResponse(Request request, List<NodeSnapshotStatus> responses, List<FailedNodeException> failures) {
        return new NodesSnapshotStatus(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeSnapshotStatus nodeOperation(NodeRequest request) {
        HashMap snapshotMapBuilder = new HashMap();
        try {
            String nodeId = this.clusterService.localNode().getId();
            for (Snapshot snapshot : request.snapshots) {
                Map<ShardId, IndexShardSnapshotStatus> shardsStatus = this.snapshotShardsService.currentSnapshotShards(snapshot);
                if (shardsStatus == null) continue;
                HashMap<ShardId, SnapshotIndexShardStatus> shardMapBuilder = new HashMap<ShardId, SnapshotIndexShardStatus>();
                for (Map.Entry<ShardId, IndexShardSnapshotStatus> shardEntry : shardsStatus.entrySet()) {
                    ShardId shardId = shardEntry.getKey();
                    IndexShardSnapshotStatus.Copy lastSnapshotStatus = shardEntry.getValue().asCopy();
                    IndexShardSnapshotStatus.Stage stage = lastSnapshotStatus.getStage();
                    String shardNodeId = null;
                    if (stage != IndexShardSnapshotStatus.Stage.DONE && stage != IndexShardSnapshotStatus.Stage.FAILURE) {
                        shardNodeId = nodeId;
                    }
                    shardMapBuilder.put(shardEntry.getKey(), new SnapshotIndexShardStatus(shardId, lastSnapshotStatus, shardNodeId));
                }
                snapshotMapBuilder.put(snapshot, Collections.unmodifiableMap(shardMapBuilder));
            }
            return new NodeSnapshotStatus(this.clusterService.localNode(), Collections.unmodifiableMap(snapshotMapBuilder));
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load metadata", (Throwable)e, new Object[0]);
        }
    }

    public static class NodeSnapshotStatus
    extends BaseNodeResponse {
        private Map<Snapshot, Map<ShardId, SnapshotIndexShardStatus>> status;

        NodeSnapshotStatus() {
        }

        public NodeSnapshotStatus(DiscoveryNode node, Map<Snapshot, Map<ShardId, SnapshotIndexShardStatus>> status) {
            super(node);
            this.status = status;
        }

        public Map<Snapshot, Map<ShardId, SnapshotIndexShardStatus>> status() {
            return this.status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            int numberOfSnapshots = in.readVInt();
            HashMap snapshotMapBuilder = new HashMap(numberOfSnapshots);
            for (int i = 0; i < numberOfSnapshots; ++i) {
                Snapshot snapshot = new Snapshot(in);
                int numberOfShards = in.readVInt();
                HashMap<ShardId, SnapshotIndexShardStatus> shardMapBuilder = new HashMap<ShardId, SnapshotIndexShardStatus>(numberOfShards);
                for (int j = 0; j < numberOfShards; ++j) {
                    ShardId shardId = ShardId.readShardId(in);
                    SnapshotIndexShardStatus status = SnapshotIndexShardStatus.readShardSnapshotStatus(in);
                    shardMapBuilder.put(shardId, status);
                }
                snapshotMapBuilder.put(snapshot, Collections.unmodifiableMap(shardMapBuilder));
            }
            this.status = Collections.unmodifiableMap(snapshotMapBuilder);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.status != null) {
                out.writeVInt(this.status.size());
                for (Map.Entry<Snapshot, Map<ShardId, SnapshotIndexShardStatus>> entry : this.status.entrySet()) {
                    entry.getKey().writeTo(out);
                    out.writeVInt(entry.getValue().size());
                    for (Map.Entry<ShardId, SnapshotIndexShardStatus> shardEntry : entry.getValue().entrySet()) {
                        shardEntry.getKey().writeTo(out);
                        shardEntry.getValue().writeTo(out);
                    }
                }
            } else {
                out.writeVInt(0);
            }
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private List<Snapshot> snapshots;

        public NodeRequest() {
        }

        NodeRequest(String nodeId, Request request) {
            super(nodeId);
            this.snapshots = Arrays.asList(request.snapshots);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.snapshots = in.readList(Snapshot::new);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeList(this.snapshots);
        }
    }

    public static class NodesSnapshotStatus
    extends BaseNodesResponse<NodeSnapshotStatus> {
        public NodesSnapshotStatus(ClusterName clusterName, List<NodeSnapshotStatus> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeSnapshotStatus> readNodesFrom(StreamInput in) throws IOException {
            return in.readStreamableList(NodeSnapshotStatus::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeSnapshotStatus> nodes) throws IOException {
            out.writeStreamableList(nodes);
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private Snapshot[] snapshots;

        public Request() {
        }

        public Request(String[] nodesIds) {
            super(nodesIds);
        }

        public Request snapshots(Snapshot[] snapshots) {
            this.snapshots = snapshots;
            return this;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            throw new UnsupportedOperationException("shouldn't be here");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException("shouldn't be here");
        }
    }
}

