/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;

public enum Priority {
    IMMEDIATE(0),
    URGENT(1),
    HIGH(2),
    NORMAL(3),
    LOW(4),
    LANGUID(5);

    private final byte value;

    public static Priority readFrom(StreamInput input) throws IOException {
        return Priority.fromByte(input.readByte());
    }

    public static void writeTo(Priority priority, StreamOutput output) throws IOException {
        output.writeByte(priority.value);
    }

    public static Priority fromByte(byte b) {
        switch (b) {
            case 0: {
                return IMMEDIATE;
            }
            case 1: {
                return URGENT;
            }
            case 2: {
                return HIGH;
            }
            case 3: {
                return NORMAL;
            }
            case 4: {
                return LOW;
            }
            case 5: {
                return LANGUID;
            }
        }
        throw new IllegalArgumentException("can't find priority for [" + b + "]");
    }

    private Priority(byte value) {
        this.value = value;
    }

    public boolean after(Priority p) {
        return this.compareTo(p) > 0;
    }

    public boolean sameOrAfter(Priority p) {
        return this.compareTo(p) >= 0;
    }
}

