/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.analysis;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.flink.elasticsearch6.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.SimpleFSDirectory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.AbstractComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.FileSystemUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.core.internal.io.IOUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.Environment;

public class HunspellService
extends AbstractComponent {
    public static final Setting<Boolean> HUNSPELL_LAZY_LOAD = Setting.boolSetting("indices.analysis.hunspell.dictionary.lazy", Boolean.FALSE, Setting.Property.NodeScope);
    public static final Setting<Boolean> HUNSPELL_IGNORE_CASE = Setting.boolSetting("indices.analysis.hunspell.dictionary.ignore_case", Boolean.FALSE, Setting.Property.NodeScope);
    public static final Setting<Settings> HUNSPELL_DICTIONARY_OPTIONS = Setting.groupSetting("indices.analysis.hunspell.dictionary.", Setting.Property.NodeScope);
    private final ConcurrentHashMap<String, Dictionary> dictionaries = new ConcurrentHashMap();
    private final Map<String, Dictionary> knownDictionaries;
    private final boolean defaultIgnoreCase;
    private final Path hunspellDir;
    private final Function<String, Dictionary> loadingFunction;

    public HunspellService(Settings settings, Environment env, Map<String, Dictionary> knownDictionaries) throws IOException {
        super(settings);
        this.knownDictionaries = Collections.unmodifiableMap(knownDictionaries);
        this.hunspellDir = this.resolveHunspellDirectory(env);
        this.defaultIgnoreCase = HUNSPELL_IGNORE_CASE.get(settings);
        this.loadingFunction = locale -> {
            try {
                return this.loadDictionary((String)locale, settings, env);
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to load hunspell dictionary for locale: " + locale, e);
            }
        };
        if (!HUNSPELL_LAZY_LOAD.get(settings).booleanValue()) {
            this.scanAndLoadDictionaries();
        }
    }

    public Dictionary getDictionary(String locale) {
        Dictionary dictionary = this.knownDictionaries.get(locale);
        if (dictionary == null) {
            dictionary = this.dictionaries.computeIfAbsent(locale, this.loadingFunction);
        }
        return dictionary;
    }

    private Path resolveHunspellDirectory(Environment env) {
        return env.configFile().resolve("hunspell");
    }

    private void scanAndLoadDictionaries() throws IOException {
        if (Files.isDirectory(this.hunspellDir, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.hunspellDir);){
                for (Path file : stream) {
                    if (!Files.isDirectory(file, new LinkOption[0])) continue;
                    DirectoryStream<Path> inner = Files.newDirectoryStream(this.hunspellDir.resolve(file), "*.dic");
                    Throwable throwable = null;
                    try {
                        if (!inner.iterator().hasNext()) continue;
                        try {
                            this.getDictionary(file.getFileName().toString());
                        }
                        catch (Exception e) {
                            this.logger.error(() -> new ParameterizedMessage("exception while loading dictionary {}", (Object)file.getFileName()), (Throwable)e);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inner == null) continue;
                        HunspellService.$closeResource(throwable, inner);
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    private Dictionary loadDictionary(String locale, Settings nodeSettings, Environment env) throws Exception {
        Path dicDir;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Loading hunspell dictionary [{}]...", (Object)locale);
        }
        if (!FileSystemUtils.isAccessibleDirectory(dicDir = this.hunspellDir.resolve(locale), this.logger)) {
            throw new ElasticsearchException(String.format(Locale.ROOT, "Could not find hunspell dictionary [%s]", locale), new Object[0]);
        }
        Settings dictSettings = HUNSPELL_DICTIONARY_OPTIONS.get(nodeSettings);
        nodeSettings = HunspellService.loadDictionarySettings(dicDir, dictSettings.getByPrefix(locale + "."));
        boolean ignoreCase = nodeSettings.getAsBoolean("ignore_case", this.defaultIgnoreCase);
        Path[] affixFiles = FileSystemUtils.files(dicDir, "*.aff");
        if (affixFiles.length == 0) {
            throw new ElasticsearchException(String.format(Locale.ROOT, "Missing affix file for hunspell dictionary [%s]", locale), new Object[0]);
        }
        if (affixFiles.length != 1) {
            throw new ElasticsearchException(String.format(Locale.ROOT, "Too many affix files exist for hunspell dictionary [%s]", locale), new Object[0]);
        }
        InputStream affixStream = null;
        Path[] dicFiles = FileSystemUtils.files(dicDir, "*.dic");
        ArrayList<InputStream> dicStreams = new ArrayList<InputStream>(dicFiles.length);
        for (int i = 0; i < dicFiles.length; ++i) {
            dicStreams.add(Files.newInputStream(dicFiles[i], new OpenOption[0]));
        }
        affixStream = Files.newInputStream(affixFiles[0], new OpenOption[0]);
        SimpleFSDirectory tmp = new SimpleFSDirectory(env.tmpFile());
        Throwable throwable = null;
        Dictionary dictionary = new Dictionary(tmp, "hunspell", affixStream, dicStreams, ignoreCase);
        HunspellService.$closeResource(throwable, tmp);
        IOUtils.close(affixStream);
        IOUtils.close(dicStreams);
        return dictionary;
        {
            catch (Throwable throwable2) {
                try {
                    try {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            HunspellService.$closeResource(throwable, tmp);
                            throw throwable3;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(() -> new ParameterizedMessage("Could not load hunspell dictionary [{}]", (Object)locale), (Throwable)e);
                        throw e;
                    }
                }
                catch (Throwable throwable4) {
                    IOUtils.close(affixStream);
                    IOUtils.close(dicStreams);
                    throw throwable4;
                }
            }
        }
    }

    private static Settings loadDictionarySettings(Path dir, Settings defaults) throws IOException {
        Path file = dir.resolve("settings.yml");
        if (Files.exists(file, new LinkOption[0])) {
            return Settings.builder().loadFromPath(file).put(defaults).build();
        }
        file = dir.resolve("settings.json");
        if (Files.exists(file, new LinkOption[0])) {
            return Settings.builder().loadFromPath(file).put(defaults).build();
        }
        return defaults;
    }
}

