/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestToXContentListener;

public class RestAnalyzeAction
extends BaseRestHandler {
    public RestAnalyzeAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_analyze", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_analyze", this);
        controller.registerHandler(RestRequest.Method.POST, "/_analyze", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_analyze", this);
    }

    @Override
    public String getName() {
        return "analyze_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        AnalyzeRequest analyzeRequest = new AnalyzeRequest(request.param("index"));
        try (XContentParser parser = request.contentOrSourceParamParser();){
            RestAnalyzeAction.buildFromContent(parser, analyzeRequest);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse request body", e);
        }
        return channel -> client.admin().indices().analyze(analyzeRequest, new RestToXContentListener<AnalyzeResponse>((RestChannel)channel));
    }

    static void buildFromContent(XContentParser parser, AnalyzeRequest analyzeRequest) throws IOException {
        XContentParser.Token token;
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Malformed content, must start with an object");
        }
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Fields.TEXT.match(currentFieldName, parser.getDeprecationHandler()) && token == XContentParser.Token.VALUE_STRING) {
                analyzeRequest.text(parser.text());
                continue;
            }
            if (Fields.TEXT.match(currentFieldName, parser.getDeprecationHandler()) && token == XContentParser.Token.START_ARRAY) {
                ArrayList<String> texts = new ArrayList<String>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (!token.isValue()) {
                        throw new IllegalArgumentException(currentFieldName + " array element should only contain text");
                    }
                    texts.add(parser.text());
                }
                analyzeRequest.text(texts.toArray(new String[texts.size()]));
                continue;
            }
            if (Fields.ANALYZER.match(currentFieldName, parser.getDeprecationHandler()) && token == XContentParser.Token.VALUE_STRING) {
                analyzeRequest.analyzer(parser.text());
                continue;
            }
            if (Fields.FIELD.match(currentFieldName, parser.getDeprecationHandler()) && token == XContentParser.Token.VALUE_STRING) {
                analyzeRequest.field(parser.text());
                continue;
            }
            if (Fields.TOKENIZER.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    analyzeRequest.tokenizer(parser.text());
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    analyzeRequest.tokenizer(parser.map());
                    continue;
                }
                throw new IllegalArgumentException(currentFieldName + " should be tokenizer's name or setting");
            }
            if (Fields.TOKEN_FILTERS.match(currentFieldName, parser.getDeprecationHandler()) && token == XContentParser.Token.START_ARRAY) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        analyzeRequest.addTokenFilter(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        analyzeRequest.addTokenFilter(parser.map());
                        continue;
                    }
                    throw new IllegalArgumentException(currentFieldName + " array element should contain filter's name or setting");
                }
                continue;
            }
            if (Fields.CHAR_FILTERS.match(currentFieldName, parser.getDeprecationHandler()) && token == XContentParser.Token.START_ARRAY) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        analyzeRequest.addCharFilter(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        analyzeRequest.addCharFilter(parser.map());
                        continue;
                    }
                    throw new IllegalArgumentException(currentFieldName + " array element should contain char filter's name or setting");
                }
                continue;
            }
            if (Fields.EXPLAIN.match(currentFieldName, parser.getDeprecationHandler())) {
                if (parser.isBooleanValue()) {
                    analyzeRequest.explain(parser.booleanValue());
                    continue;
                }
                throw new IllegalArgumentException(currentFieldName + " must be either 'true' or 'false'");
            }
            if (Fields.ATTRIBUTES.match(currentFieldName, parser.getDeprecationHandler()) && token == XContentParser.Token.START_ARRAY) {
                ArrayList<String> attributes = new ArrayList<String>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (!token.isValue()) {
                        throw new IllegalArgumentException(currentFieldName + " array element should only contain attribute name");
                    }
                    attributes.add(parser.text());
                }
                analyzeRequest.attributes(attributes.toArray(new String[attributes.size()]));
                continue;
            }
            if (Fields.NORMALIZER.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    analyzeRequest.normalizer(parser.text());
                    continue;
                }
                throw new IllegalArgumentException(currentFieldName + " should be normalizer's name");
            }
            throw new IllegalArgumentException("Unknown parameter [" + currentFieldName + "] in request body or parameter is of the wrong type[" + (Object)((Object)token) + "] ");
        }
    }

    public static class Fields {
        public static final ParseField ANALYZER = new ParseField("analyzer", new String[0]);
        public static final ParseField TEXT = new ParseField("text", new String[0]);
        public static final ParseField FIELD = new ParseField("field", new String[0]);
        public static final ParseField TOKENIZER = new ParseField("tokenizer", new String[0]);
        public static final ParseField TOKEN_FILTERS = new ParseField("filter", new String[0]);
        public static final ParseField CHAR_FILTERS = new ParseField("char_filter", new String[0]);
        public static final ParseField EXPLAIN = new ParseField("explain", new String[0]);
        public static final ParseField ATTRIBUTES = new ParseField("attributes", new String[0]);
        public static final ParseField NORMALIZER = new ParseField("normalizer", new String[0]);
    }
}

