/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.admin.indices;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.AliasMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MappingMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.IndexScopedSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.SettingsFilter;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BytesRestResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetIndicesAction
extends BaseRestHandler {
    private final IndexScopedSettings indexScopedSettings;
    private final SettingsFilter settingsFilter;

    public RestGetIndicesAction(Settings settings, RestController controller, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter) {
        super(settings);
        this.indexScopedSettings = indexScopedSettings;
        controller.registerHandler(RestRequest.Method.GET, "/{index}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public String getName() {
        return "get_indices_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final GetIndexRequest getIndexRequest = new GetIndexRequest();
        getIndexRequest.indices(indices);
        getIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, getIndexRequest.indicesOptions()));
        getIndexRequest.local(request.paramAsBoolean("local", getIndexRequest.local()));
        getIndexRequest.humanReadable(request.paramAsBoolean("human", false));
        final boolean defaults = request.paramAsBoolean("include_defaults", false);
        return channel -> client.admin().indices().getIndex(getIndexRequest, (ActionListener<GetIndexResponse>)new RestBuilderListener<GetIndexResponse>(channel){

            @Override
            public RestResponse buildResponse(GetIndexResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (String index : response.indices()) {
                    builder.startObject(index);
                    block6: for (GetIndexRequest.Feature feature : getIndexRequest.features()) {
                        switch (feature) {
                            case ALIASES: {
                                this.writeAliases(response.aliases().get(index), builder, request);
                                continue block6;
                            }
                            case MAPPINGS: {
                                this.writeMappings(response.mappings().get(index), builder);
                                continue block6;
                            }
                            case SETTINGS: {
                                this.writeSettings(response.settings().get(index), builder, request, defaults);
                                continue block6;
                            }
                            default: {
                                throw new IllegalStateException("feature [" + (Object)((Object)feature) + "] is not valid");
                            }
                        }
                    }
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }

            private void writeAliases(List<AliasMetaData> aliases, XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject("aliases");
                if (aliases != null) {
                    for (AliasMetaData alias : aliases) {
                        AliasMetaData.Builder.toXContent(alias, builder, params);
                    }
                }
                builder.endObject();
            }

            private void writeMappings(ImmutableOpenMap<String, MappingMetaData> mappings, XContentBuilder builder) throws IOException {
                builder.startObject("mappings");
                if (mappings != null) {
                    for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : mappings) {
                        builder.field((String)objectObjectCursor.key);
                        builder.map(((MappingMetaData)objectObjectCursor.value).sourceAsMap());
                    }
                }
                builder.endObject();
            }

            private void writeSettings(Settings settings, XContentBuilder builder, ToXContent.Params params, boolean defaults2) throws IOException {
                builder.startObject("settings");
                settings.toXContent(builder, params);
                builder.endObject();
                if (defaults2) {
                    builder.startObject("defaults");
                    RestGetIndicesAction.this.settingsFilter.filter(RestGetIndicesAction.this.indexScopedSettings.diff(settings, RestGetIndicesAction.this.settings)).toXContent(builder, request);
                    builder.endObject();
                }
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }
}

