/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.flush.SyncedFlushRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.flush.SyncedFlushResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BytesRestResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestBuilderListener;

public class RestSyncedFlushAction
extends BaseRestHandler {
    public RestSyncedFlushAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_flush/synced", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_flush/synced", this);
        controller.registerHandler(RestRequest.Method.GET, "/_flush/synced", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_flush/synced", this);
    }

    @Override
    public String getName() {
        return "synced_flush_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        IndicesOptions indicesOptions = IndicesOptions.fromRequest(request, IndicesOptions.lenientExpandOpen());
        SyncedFlushRequest syncedFlushRequest = new SyncedFlushRequest(Strings.splitStringByCommaToArray(request.param("index")));
        syncedFlushRequest.indicesOptions(indicesOptions);
        return channel -> client.admin().indices().syncedFlush(syncedFlushRequest, (ActionListener<SyncedFlushResponse>)new RestBuilderListener<SyncedFlushResponse>(channel){

            @Override
            public RestResponse buildResponse(SyncedFlushResponse results, XContentBuilder builder) throws Exception {
                builder.startObject();
                results.toXContent(builder, request);
                builder.endObject();
                return new BytesRestResponse(results.restStatus(), builder);
            }
        });
    }
}

