/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.function.IntConsumer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.Loggers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregationExecutionException;

public class MultiBucketConsumerService {
    public static final int DEFAULT_LIMIT_MAX_BUCKETS = -1;
    public static final int SOFT_LIMIT_MAX_BUCKETS = 10000;
    public static final Setting<Integer> MAX_BUCKET_SETTING = Setting.intSetting("search.max_buckets", -1, -1, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile int maxBucket;

    public MultiBucketConsumerService(ClusterService clusterService, Settings settings) {
        this.maxBucket = MAX_BUCKET_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_BUCKET_SETTING, this::setMaxBucket);
    }

    private void setMaxBucket(int maxBucket) {
        this.maxBucket = maxBucket;
    }

    public MultiBucketConsumer create() {
        return new MultiBucketConsumer(this.maxBucket);
    }

    public static class MultiBucketConsumer
    implements IntConsumer {
        private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(MultiBucketConsumerService.class));
        private final int limit;
        private int count;
        private boolean hasLogged = false;

        public MultiBucketConsumer(int limit) {
            this.limit = limit;
        }

        @Override
        public void accept(int value) {
            this.count += value;
            if (this.limit == -1) {
                if (!this.hasLogged && this.count > 10000) {
                    DEPRECATION_LOGGER.deprecated("This aggregation creates too many buckets (" + this.count + ") and will throw an error in future versions. You should update the [search.max_buckets] cluster setting or use the [composite] aggregation to paginate all buckets in multiple requests.", new Object[0]);
                    this.hasLogged = true;
                }
            } else if (this.count > this.limit) {
                throw new TooManyBucketsException("Trying to create too many buckets. Must be less than or equal to: [" + this.limit + "] but was [" + this.count + "]. This limit can be set by changing the [" + MAX_BUCKET_SETTING.getKey() + "] cluster level setting.", this.limit);
            }
        }

        public void reset() {
            this.count = 0;
            this.hasLogged = false;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class TooManyBucketsException
    extends AggregationExecutionException {
        private final int maxBuckets;

        public TooManyBucketsException(String message, int maxBuckets) {
            super(message);
            this.maxBuckets = maxBuckets;
        }

        public TooManyBucketsException(StreamInput in) throws IOException {
            super(in);
            this.maxBuckets = in.readInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.maxBuckets);
        }

        public int getMaxBuckets() {
            return this.maxBuckets;
        }

        @Override
        public RestStatus status() {
            return RestStatus.SERVICE_UNAVAILABLE;
        }

        @Override
        protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("max_buckets", this.maxBuckets);
        }
    }
}

