/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeMap;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.CompositeKey;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.SingleDimensionValuesSource;

final class CompositeValuesCollectorQueue
implements Releasable {
    private static final int CANDIDATE_SLOT = Integer.MAX_VALUE;
    private final int maxSize;
    private final TreeMap<Integer, Integer> keys;
    private final SingleDimensionValuesSource<?>[] arrays;
    private final int[] docCounts;
    private boolean afterValueSet = false;

    CompositeValuesCollectorQueue(SingleDimensionValuesSource<?>[] sources, int size) {
        this.maxSize = size;
        this.arrays = sources;
        this.docCounts = new int[size];
        this.keys = new TreeMap(this::compare);
    }

    void clear() {
        this.keys.clear();
        Arrays.fill(this.docCounts, 0);
        this.afterValueSet = false;
    }

    int size() {
        return this.keys.size();
    }

    boolean isFull() {
        return this.keys.size() == this.maxSize;
    }

    Set<Integer> getSortedSlot() {
        return this.keys.keySet();
    }

    Integer compareCurrent() {
        return this.keys.get(Integer.MAX_VALUE);
    }

    Comparable<?> getLowerValueLeadSource() {
        return this.afterValueSet ? (Comparable<?>)this.arrays[0].getAfter() : null;
    }

    Comparable<?> getUpperValueLeadSource() throws IOException {
        return this.size() >= this.maxSize ? (Comparable<?>)this.arrays[0].toComparable(this.keys.lastKey()) : null;
    }

    int getDocCount(int slot) {
        return this.docCounts[slot];
    }

    private void copyCurrent(int slot) {
        for (int i = 0; i < this.arrays.length; ++i) {
            this.arrays[i].copyCurrent(slot);
        }
        this.docCounts[slot] = 1;
    }

    int compare(int slot1, int slot2) {
        for (int i = 0; i < this.arrays.length; ++i) {
            int cmp;
            int n = cmp = slot1 == Integer.MAX_VALUE ? this.arrays[i].compareCurrent(slot2) : this.arrays[i].compare(slot1, slot2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    void setAfter(Comparable<?>[] values) {
        assert (values.length == this.arrays.length);
        this.afterValueSet = true;
        for (int i = 0; i < this.arrays.length; ++i) {
            this.arrays[i].setAfter(values[i]);
        }
    }

    private int compareCurrentWithAfter() {
        for (int i = 0; i < this.arrays.length; ++i) {
            int cmp = this.arrays[i].compareCurrentWithAfter();
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    CompositeKey toCompositeKey(int slot) throws IOException {
        assert (slot < this.maxSize);
        Comparable[] values = new Comparable[this.arrays.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.arrays[i].toComparable(slot);
        }
        return new CompositeKey(values);
    }

    LeafBucketCollector getLeafCollector(LeafReaderContext context, LeafBucketCollector in) throws IOException {
        return this.getLeafCollector(null, context, in);
    }

    LeafBucketCollector getLeafCollector(Comparable<?> forceLeadSourceValue, LeafReaderContext context, LeafBucketCollector in) throws IOException {
        int last = this.arrays.length - 1;
        LeafBucketCollector collector = in;
        while (last > 0) {
            collector = this.arrays[last--].getLeafCollector(context, collector);
        }
        collector = forceLeadSourceValue != null ? this.arrays[last].getLeafCollector(forceLeadSourceValue, context, collector) : this.arrays[last].getLeafCollector(context, collector);
        return collector;
    }

    int addIfCompetitive() {
        int newSlot;
        Integer topSlot = this.compareCurrent();
        if (topSlot != null) {
            int n = topSlot;
            this.docCounts[n] = this.docCounts[n] + 1;
            return topSlot;
        }
        if (this.afterValueSet && this.compareCurrentWithAfter() <= 0) {
            return -1;
        }
        if (this.keys.size() >= this.maxSize && this.compare(Integer.MAX_VALUE, this.keys.lastKey()) > 0) {
            return -1;
        }
        if (this.keys.size() >= this.maxSize) {
            int slot;
            newSlot = slot = this.keys.pollLastEntry().getKey().intValue();
        } else {
            newSlot = this.keys.size();
            assert (newSlot < this.maxSize);
        }
        this.copyCurrent(newSlot);
        this.keys.put(newSlot, newSlot);
        return newSlot;
    }

    @Override
    public void close() {
        Releasables.close(this.arrays);
    }
}

