/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;

public class ParsedComposite
extends ParsedMultiBucketAggregation<ParsedBucket>
implements CompositeAggregation {
    private static ObjectParser<ParsedComposite, Void> PARSER = new ObjectParser(ParsedComposite.class.getSimpleName(), true, ParsedComposite::new);
    private Map<String, Object> afterKey;

    public static ParsedComposite fromXContent(XContentParser parser, String name) throws IOException {
        ParsedComposite aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        if (aggregation.afterKey == null && aggregation.getBuckets().size() > 0) {
            aggregation.setAfterKey(aggregation.getBuckets().get(aggregation.getBuckets().size() - 1).key);
        }
        return aggregation;
    }

    @Override
    public String getType() {
        return "composite";
    }

    public List<ParsedBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public Map<String, Object> afterKey() {
        if (this.afterKey != null) {
            return this.afterKey;
        }
        return this.buckets.size() > 0 ? ((ParsedBucket)this.buckets.get(this.buckets.size() - 1)).getKey() : null;
    }

    private void setAfterKey(Map<String, Object> afterKey) {
        this.afterKey = afterKey;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return CompositeAggregation.toXContentFragment(this, builder, params);
    }

    static {
        PARSER.declareField(ParsedComposite::setAfterKey, (p, c) -> p.mapOrdered(), new ParseField("after_key", new String[0]), ObjectParser.ValueType.OBJECT);
        ParsedComposite.declareMultiBucketAggregationFields(PARSER, parser -> ParsedBucket.fromXContent(parser), parser -> null);
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements CompositeAggregation.Bucket {
        private Map<String, Object> key;

        @Override
        public String getKeyAsString() {
            return this.key.toString();
        }

        @Override
        public Map<String, Object> getKey() {
            return this.key;
        }

        void setKey(Map<String, Object> key) {
            this.key = key;
        }

        @Override
        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException("not implemented");
        }

        static ParsedBucket fromXContent(XContentParser parser) throws IOException {
            return ParsedBucket.parseXContent(parser, false, ParsedBucket::new, (p, bucket) -> bucket.setKey(p.mapOrdered()));
        }
    }
}

