/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.query;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.AbstractInternalProfileTree;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.profile.query.QueryProfileBreakdown;

final class InternalQueryProfileTree
extends AbstractInternalProfileTree<QueryProfileBreakdown, Query> {
    private long rewriteTime;
    private long rewriteScratch;

    InternalQueryProfileTree() {
    }

    @Override
    protected QueryProfileBreakdown createProfileBreakdown() {
        return new QueryProfileBreakdown();
    }

    @Override
    protected String getTypeFromElement(Query query) {
        if (query.getClass().getSimpleName().isEmpty()) {
            return query.getClass().getSuperclass().getSimpleName();
        }
        return query.getClass().getSimpleName();
    }

    @Override
    protected String getDescriptionFromElement(Query query) {
        return query.toString();
    }

    public void startRewriteTime() {
        assert (this.rewriteScratch == 0L);
        this.rewriteScratch = System.nanoTime();
    }

    public long stopAndAddRewriteTime() {
        long time = Math.max(1L, System.nanoTime() - this.rewriteScratch);
        this.rewriteTime += time;
        this.rewriteScratch = 0L;
        return time;
    }

    public long getRewriteTime() {
        return this.rewriteTime;
    }
}

