/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.query;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.SearchPhaseResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.SearchShardTarget;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.query.QuerySearchResult;

public final class ScrollQuerySearchResult
extends SearchPhaseResult {
    private QuerySearchResult result;

    public ScrollQuerySearchResult() {
    }

    public ScrollQuerySearchResult(QuerySearchResult result, SearchShardTarget shardTarget) {
        this.result = result;
        this.setSearchShardTarget(shardTarget);
    }

    @Override
    public void setSearchShardTarget(SearchShardTarget shardTarget) {
        super.setSearchShardTarget(shardTarget);
        this.result.setSearchShardTarget(shardTarget);
    }

    @Override
    public void setShardIndex(int shardIndex) {
        super.setShardIndex(shardIndex);
        this.result.setShardIndex(shardIndex);
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        SearchShardTarget shardTarget = new SearchShardTarget(in);
        this.result = QuerySearchResult.readQuerySearchResult(in);
        this.setSearchShardTarget(shardTarget);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.getSearchShardTarget().writeTo(out);
        this.result.writeTo(out);
    }
}

