/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.CheckedBiConsumer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.breaker.CircuitBreaker;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.component.LifecycleComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.transport.BoundTransportAddress;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.transport.TransportAddress;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.ConnectTransportException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.ConnectionProfile;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportRequestOptions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportStats;

public interface Transport
extends LifecycleComponent {
    public static final Setting<Boolean> TRANSPORT_TCP_COMPRESS = Setting.boolSetting("transport.tcp.compress", false, Setting.Property.NodeScope);

    public void setTransportService(TransportService var1);

    public BoundTransportAddress boundAddress();

    public Map<String, BoundTransportAddress> profileBoundAddresses();

    public TransportAddress[] addressesFromString(String var1, int var2) throws UnknownHostException;

    public boolean nodeConnected(DiscoveryNode var1);

    public void connectToNode(DiscoveryNode var1, ConnectionProfile var2, CheckedBiConsumer<Connection, ConnectionProfile, IOException> var3) throws ConnectTransportException;

    public void disconnectFromNode(DiscoveryNode var1);

    public List<String> getLocalAddresses();

    default public CircuitBreaker getInFlightRequestBreaker() {
        return new NoopCircuitBreaker("in-flight-noop");
    }

    public long newRequestId();

    public Connection getConnection(DiscoveryNode var1);

    public Connection openConnection(DiscoveryNode var1, ConnectionProfile var2) throws IOException;

    public TransportStats getStats();

    public static interface Connection
    extends Closeable {
        public DiscoveryNode getNode();

        public void sendRequest(long var1, String var3, TransportRequest var4, TransportRequestOptions var5) throws IOException, TransportException;

        default public Version getVersion() {
            return this.getNode().getVersion();
        }

        default public Object getCacheKey() {
            return this;
        }
    }
}

