/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.ApiVersions;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.Callback;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals.BufferPool;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals.IncompleteBatches;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals.ProducerBatch;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals.ProducerIdAndEpoch;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals.TransactionManager;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Cluster;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.MetricName;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Node;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.PartitionInfo;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.header.Header;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.Measurable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.MetricConfig;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.Metrics;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.Sensor;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.stats.Meter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.record.AbstractRecords;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.record.CompressionRatioEstimator;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.record.CompressionType;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.record.MemoryRecords;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.record.Record;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.record.TimestampType;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.CopyOnWriteMap;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Time;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public final class RecordAccumulator {
    private final Logger log;
    private volatile boolean closed;
    private final AtomicInteger flushesInProgress;
    private final AtomicInteger appendsInProgress;
    private final int batchSize;
    private final CompressionType compression;
    private final long lingerMs;
    private final long retryBackoffMs;
    private final long deliveryTimeoutMs;
    private final BufferPool free;
    private final Time time;
    private final ApiVersions apiVersions;
    private final ConcurrentMap<TopicPartition, Deque<ProducerBatch>> batches;
    private final IncompleteBatches incomplete;
    private final Map<TopicPartition, Long> muted;
    private int drainIndex;
    private final TransactionManager transactionManager;
    private long nextBatchExpiryTimeMs = Long.MAX_VALUE;

    public RecordAccumulator(LogContext logContext, int batchSize, CompressionType compression, long lingerMs, long retryBackoffMs, long deliveryTimeoutMs, Metrics metrics, String metricGrpName, Time time, ApiVersions apiVersions, TransactionManager transactionManager, BufferPool bufferPool) {
        this.log = logContext.logger(RecordAccumulator.class);
        this.drainIndex = 0;
        this.closed = false;
        this.flushesInProgress = new AtomicInteger(0);
        this.appendsInProgress = new AtomicInteger(0);
        this.batchSize = batchSize;
        this.compression = compression;
        this.lingerMs = lingerMs;
        this.retryBackoffMs = retryBackoffMs;
        this.deliveryTimeoutMs = deliveryTimeoutMs;
        this.batches = new CopyOnWriteMap<TopicPartition, Deque<ProducerBatch>>();
        this.free = bufferPool;
        this.incomplete = new IncompleteBatches();
        this.muted = new HashMap<TopicPartition, Long>();
        this.time = time;
        this.apiVersions = apiVersions;
        this.transactionManager = transactionManager;
        this.registerMetrics(metrics, metricGrpName);
    }

    private void registerMetrics(Metrics metrics, String metricGrpName) {
        MetricName metricName = metrics.metricName("waiting-threads", metricGrpName, "The number of user threads blocked waiting for buffer memory to enqueue their records");
        Measurable waitingThreads = new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.queued();
            }
        };
        metrics.addMetric(metricName, waitingThreads);
        metricName = metrics.metricName("buffer-total-bytes", metricGrpName, "The maximum amount of buffer memory the client can use (whether or not it is currently used).");
        Measurable totalBytes = new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.totalMemory();
            }
        };
        metrics.addMetric(metricName, totalBytes);
        metricName = metrics.metricName("buffer-available-bytes", metricGrpName, "The total amount of buffer memory that is not being used (either unallocated or in the free list).");
        Measurable availableBytes = new Measurable(){

            @Override
            public double measure(MetricConfig config, long now) {
                return RecordAccumulator.this.free.availableMemory();
            }
        };
        metrics.addMetric(metricName, availableBytes);
        Sensor bufferExhaustedRecordSensor = metrics.sensor("buffer-exhausted-records");
        MetricName rateMetricName = metrics.metricName("buffer-exhausted-rate", metricGrpName, "The average per-second number of record sends that are dropped due to buffer exhaustion");
        MetricName totalMetricName = metrics.metricName("buffer-exhausted-total", metricGrpName, "The total number of record sends that are dropped due to buffer exhaustion");
        bufferExhaustedRecordSensor.add(new Meter(rateMetricName, totalMetricName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public RecordAppendResult append(TopicPartition tp, long timestamp, byte[] key, byte[] value, Header[] headers, Callback callback, long maxTimeToBlock) throws InterruptedException {
        byte maxUsableMagic;
        Deque<ProducerBatch> dq;
        ByteBuffer buffer;
        block18: {
            block17: {
                RecordAppendResult recordAppendResult;
                this.appendsInProgress.incrementAndGet();
                buffer = null;
                if (headers == null) {
                    headers = Record.EMPTY_HEADERS;
                }
                try {
                    Deque<ProducerBatch> deque = dq = this.getOrCreateDeque(tp);
                    // MONITORENTER : deque
                    if (this.closed) {
                        throw new KafkaException("Producer closed while send in progress");
                    }
                    RecordAppendResult appendResult = this.tryAppend(timestamp, key, value, headers, callback, dq);
                    if (appendResult == null) break block17;
                    recordAppendResult = appendResult;
                    // MONITOREXIT : deque
                    if (buffer != null) {
                        this.free.deallocate(buffer);
                    }
                    this.appendsInProgress.decrementAndGet();
                }
                catch (Throwable throwable) {
                    if (buffer != null) {
                        this.free.deallocate(buffer);
                    }
                    this.appendsInProgress.decrementAndGet();
                    throw throwable;
                }
                return recordAppendResult;
            }
            // MONITOREXIT : deque
            maxUsableMagic = this.apiVersions.maxUsableProduceMagic();
            int size = Math.max(this.batchSize, AbstractRecords.estimateSizeInBytesUpperBound(maxUsableMagic, this.compression, key, value, headers));
            this.log.trace("Allocating a new {} byte message buffer for topic {} partition {}", new Object[]{size, tp.topic(), tp.partition()});
            buffer = this.free.allocate(size, maxTimeToBlock);
            Deque<ProducerBatch> deque = dq;
            // MONITORENTER : deque
            if (this.closed) {
                throw new KafkaException("Producer closed while send in progress");
            }
            RecordAppendResult appendResult = this.tryAppend(timestamp, key, value, headers, callback, dq);
            if (appendResult == null) break block18;
            RecordAppendResult recordAppendResult = appendResult;
            // MONITOREXIT : deque
            if (buffer != null) {
                this.free.deallocate(buffer);
            }
            this.appendsInProgress.decrementAndGet();
            return recordAppendResult;
        }
        MemoryRecordsBuilder recordsBuilder = this.recordsBuilder(buffer, maxUsableMagic);
        ProducerBatch batch = new ProducerBatch(tp, recordsBuilder, this.time.milliseconds());
        FutureRecordMetadata future = Utils.notNull(batch.tryAppend(timestamp, key, value, headers, callback, this.time.milliseconds()));
        dq.addLast(batch);
        this.incomplete.add(batch);
        buffer = null;
        RecordAppendResult recordAppendResult = new RecordAppendResult(future, dq.size() > 1 || batch.isFull(), true);
        // MONITOREXIT : deque
        if (buffer != null) {
            this.free.deallocate(buffer);
        }
        this.appendsInProgress.decrementAndGet();
        return recordAppendResult;
    }

    private MemoryRecordsBuilder recordsBuilder(ByteBuffer buffer, byte maxUsableMagic) {
        if (this.transactionManager != null && maxUsableMagic < 2) {
            throw new UnsupportedVersionException("Attempting to use idempotence with a broker which does not support the required message format (v2). The broker must be version 0.11 or later.");
        }
        return MemoryRecords.builder(buffer, maxUsableMagic, this.compression, TimestampType.CREATE_TIME, 0L);
    }

    private RecordAppendResult tryAppend(long timestamp, byte[] key, byte[] value, Header[] headers, Callback callback, Deque<ProducerBatch> deque) {
        ProducerBatch last = deque.peekLast();
        if (last != null) {
            FutureRecordMetadata future = last.tryAppend(timestamp, key, value, headers, callback, this.time.milliseconds());
            if (future == null) {
                last.closeForRecordAppends();
            } else {
                return new RecordAppendResult(future, deque.size() > 1 || last.isFull(), false);
            }
        }
        return null;
    }

    private boolean isMuted(TopicPartition tp, long now) {
        boolean result;
        boolean bl = result = this.muted.containsKey(tp) && this.muted.get(tp) > now;
        if (!result) {
            this.muted.remove(tp);
        }
        return result;
    }

    public void resetNextBatchExpiryTime() {
        this.nextBatchExpiryTimeMs = Long.MAX_VALUE;
    }

    public void maybeUpdateNextBatchExpiryTime(ProducerBatch batch) {
        if (batch.createdMs + this.deliveryTimeoutMs > 0L) {
            this.nextBatchExpiryTimeMs = Math.min(this.nextBatchExpiryTimeMs, batch.createdMs + this.deliveryTimeoutMs);
        } else {
            this.log.warn("Skipping next batch expiry time update due to addition overflow: batch.createMs={}, deliveryTimeoutMs={}", (Object)batch.createdMs, (Object)this.deliveryTimeoutMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProducerBatch> expiredBatches(long now) {
        ArrayList<ProducerBatch> expiredBatches = new ArrayList<ProducerBatch>();
        for (Map.Entry entry : this.batches.entrySet()) {
            Deque deque;
            Deque deque2 = deque = (Deque)entry.getValue();
            synchronized (deque2) {
                while (!deque.isEmpty()) {
                    ProducerBatch batch = (ProducerBatch)deque.getFirst();
                    if (batch.hasReachedDeliveryTimeout(this.deliveryTimeoutMs, now)) {
                        deque.poll();
                        batch.abortRecordAppends();
                        expiredBatches.add(batch);
                        continue;
                    }
                    this.maybeUpdateNextBatchExpiryTime(batch);
                    break;
                }
            }
        }
        return expiredBatches;
    }

    public long getDeliveryTimeoutMs() {
        return this.deliveryTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reenqueue(ProducerBatch batch, long now) {
        Deque<ProducerBatch> deque;
        batch.reenqueued(now);
        Deque<ProducerBatch> deque2 = deque = this.getOrCreateDeque(batch.topicPartition);
        synchronized (deque2) {
            if (this.transactionManager != null) {
                this.insertInSequenceOrder(deque, batch);
            } else {
                deque.addFirst(batch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int splitAndReenqueue(ProducerBatch bigBatch) {
        CompressionRatioEstimator.setEstimation(bigBatch.topicPartition.topic(), this.compression, Math.max(1.0f, (float)bigBatch.compressionRatio()));
        Deque<ProducerBatch> dq = bigBatch.split(this.batchSize);
        int numSplitBatches = dq.size();
        Deque<ProducerBatch> partitionDequeue = this.getOrCreateDeque(bigBatch.topicPartition);
        while (!dq.isEmpty()) {
            ProducerBatch batch = dq.pollLast();
            this.incomplete.add(batch);
            Deque<ProducerBatch> deque = partitionDequeue;
            synchronized (deque) {
                if (this.transactionManager != null) {
                    this.transactionManager.addInFlightBatch(batch);
                    this.insertInSequenceOrder(partitionDequeue, batch);
                } else {
                    partitionDequeue.addFirst(batch);
                }
            }
        }
        return numSplitBatches;
    }

    private void insertInSequenceOrder(Deque<ProducerBatch> deque, ProducerBatch batch) {
        if (batch.baseSequence() == -1) {
            throw new IllegalStateException("Trying to re-enqueue a batch which doesn't have a sequence even though idempotency is enabled.");
        }
        if (this.transactionManager.nextBatchBySequence(batch.topicPartition) == null) {
            throw new IllegalStateException("We are re-enqueueing a batch which is not tracked as part of the in flight requests. batch.topicPartition: " + batch.topicPartition + "; batch.baseSequence: " + batch.baseSequence());
        }
        ProducerBatch firstBatchInQueue = deque.peekFirst();
        if (firstBatchInQueue != null && firstBatchInQueue.hasSequence() && firstBatchInQueue.baseSequence() < batch.baseSequence()) {
            ArrayList<ProducerBatch> orderedBatches = new ArrayList<ProducerBatch>();
            while (deque.peekFirst() != null && deque.peekFirst().hasSequence() && deque.peekFirst().baseSequence() < batch.baseSequence()) {
                orderedBatches.add(deque.pollFirst());
            }
            this.log.debug("Reordered incoming batch with sequence {} for partition {}. It was placed in the queue at position {}", new Object[]{batch.baseSequence(), batch.topicPartition, orderedBatches.size()});
            deque.addFirst(batch);
            for (int i = orderedBatches.size() - 1; i >= 0; --i) {
                deque.addFirst((ProducerBatch)orderedBatches.get(i));
            }
        } else {
            deque.addFirst(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadyCheckResult ready(Cluster cluster, long nowMs) {
        HashSet<Node> readyNodes = new HashSet<Node>();
        long nextReadyCheckDelayMs = Long.MAX_VALUE;
        HashSet<String> unknownLeaderTopics = new HashSet<String>();
        boolean exhausted = this.free.queued() > 0;
        for (Map.Entry entry : this.batches.entrySet()) {
            TopicPartition part = (TopicPartition)entry.getKey();
            Deque deque = (Deque)entry.getValue();
            Node leader = cluster.leaderFor(part);
            Deque deque2 = deque;
            synchronized (deque2) {
                ProducerBatch batch;
                if (leader == null && !deque.isEmpty()) {
                    unknownLeaderTopics.add(part.topic());
                } else if (!readyNodes.contains(leader) && !this.isMuted(part, nowMs) && (batch = (ProducerBatch)deque.peekFirst()) != null) {
                    boolean sendable;
                    long waitedTimeMs = batch.waitedTimeMs(nowMs);
                    boolean backingOff = batch.attempts() > 0 && waitedTimeMs < this.retryBackoffMs;
                    long timeToWaitMs = backingOff ? this.retryBackoffMs : this.lingerMs;
                    boolean full = deque.size() > 1 || batch.isFull();
                    boolean expired = waitedTimeMs >= timeToWaitMs;
                    boolean bl = sendable = full || expired || exhausted || this.closed || this.flushInProgress();
                    if (sendable && !backingOff) {
                        readyNodes.add(leader);
                    } else {
                        long timeLeftMs = Math.max(timeToWaitMs - waitedTimeMs, 0L);
                        nextReadyCheckDelayMs = Math.min(timeLeftMs, nextReadyCheckDelayMs);
                    }
                }
            }
        }
        return new ReadyCheckResult(readyNodes, nextReadyCheckDelayMs, unknownLeaderTopics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUndrained() {
        for (Map.Entry entry : this.batches.entrySet()) {
            Deque deque;
            Deque deque2 = deque = (Deque)entry.getValue();
            synchronized (deque2) {
                if (!deque.isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean shouldStopDrainBatchesForPartition(ProducerBatch first, TopicPartition tp) {
        ProducerIdAndEpoch producerIdAndEpoch = null;
        if (this.transactionManager != null) {
            if (!this.transactionManager.isSendToPartitionAllowed(tp)) {
                return true;
            }
            producerIdAndEpoch = this.transactionManager.producerIdAndEpoch();
            if (!producerIdAndEpoch.isValid()) {
                return true;
            }
            if (!first.hasSequence() && this.transactionManager.hasUnresolvedSequence(first.topicPartition)) {
                return true;
            }
            int firstInFlightSequence = this.transactionManager.firstInFlightSequence(first.topicPartition);
            if (firstInFlightSequence != -1 && first.hasSequence() && first.baseSequence() != firstInFlightSequence) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProducerBatch> drainBatchesForOneNode(Cluster cluster, Node node, int maxSize, long now) {
        int size = 0;
        List<PartitionInfo> parts = cluster.partitionsForNode(node.id());
        ArrayList<ProducerBatch> ready = new ArrayList<ProducerBatch>();
        int start = this.drainIndex %= parts.size();
        do {
            Deque<ProducerBatch> deque;
            PartitionInfo part = parts.get(this.drainIndex);
            TopicPartition tp = new TopicPartition(part.topic(), part.partition());
            this.drainIndex = (this.drainIndex + 1) % parts.size();
            if (this.isMuted(tp, now) || (deque = this.getDeque(tp)) == null) continue;
            Deque<ProducerBatch> deque2 = deque;
            synchronized (deque2) {
                boolean backoff;
                ProducerBatch first = deque.peekFirst();
                if (first == null) {
                    continue;
                }
                boolean bl = backoff = first.attempts() > 0 && first.waitedTimeMs(now) < this.retryBackoffMs;
                if (backoff) {
                    continue;
                }
                if (size + first.estimatedSizeInBytes() > maxSize && !ready.isEmpty()) {
                    break;
                }
                if (this.shouldStopDrainBatchesForPartition(first, tp)) {
                    break;
                }
                boolean isTransactional = this.transactionManager != null ? this.transactionManager.isTransactional() : false;
                ProducerIdAndEpoch producerIdAndEpoch = this.transactionManager != null ? this.transactionManager.producerIdAndEpoch() : null;
                ProducerBatch batch = deque.pollFirst();
                if (producerIdAndEpoch != null && !batch.hasSequence()) {
                    batch.setProducerState(producerIdAndEpoch, this.transactionManager.sequenceNumber(batch.topicPartition), isTransactional);
                    this.transactionManager.incrementSequenceNumber(batch.topicPartition, batch.recordCount);
                    this.log.debug("Assigned producerId {} and producerEpoch {} to batch with base sequence {} being sent to partition {}", new Object[]{producerIdAndEpoch.producerId, producerIdAndEpoch.epoch, batch.baseSequence(), tp});
                    this.transactionManager.addInFlightBatch(batch);
                }
                batch.close();
                size += batch.records().sizeInBytes();
                ready.add(batch);
                batch.drained(now);
            }
        } while (start != this.drainIndex);
        return ready;
    }

    public Map<Integer, List<ProducerBatch>> drain(Cluster cluster, Set<Node> nodes, int maxSize, long now) {
        if (nodes.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<ProducerBatch>> batches = new HashMap<Integer, List<ProducerBatch>>();
        for (Node node : nodes) {
            List<ProducerBatch> ready = this.drainBatchesForOneNode(cluster, node, maxSize, now);
            batches.put(node.id(), ready);
        }
        return batches;
    }

    public Long nextExpiryTimeMs() {
        return this.nextBatchExpiryTimeMs;
    }

    private Deque<ProducerBatch> getDeque(TopicPartition tp) {
        return (Deque)this.batches.get(tp);
    }

    private Deque<ProducerBatch> getOrCreateDeque(TopicPartition tp) {
        ArrayDeque<ProducerBatch> d = (ArrayDeque<ProducerBatch>)this.batches.get(tp);
        if (d != null) {
            return d;
        }
        d = new ArrayDeque<ProducerBatch>();
        Deque previous = this.batches.putIfAbsent(tp, d);
        if (previous == null) {
            return d;
        }
        return previous;
    }

    public void deallocate(ProducerBatch batch) {
        this.incomplete.remove(batch);
        if (!batch.isSplitBatch()) {
            this.free.deallocate(batch.buffer(), batch.initialCapacity());
        }
    }

    long bufferPoolAvailableMemory() {
        return this.free.availableMemory();
    }

    boolean flushInProgress() {
        return this.flushesInProgress.get() > 0;
    }

    Map<TopicPartition, Deque<ProducerBatch>> batches() {
        return Collections.unmodifiableMap(this.batches);
    }

    public void beginFlush() {
        this.flushesInProgress.getAndIncrement();
    }

    private boolean appendsInProgress() {
        return this.appendsInProgress.get() > 0;
    }

    public void awaitFlushCompletion() throws InterruptedException {
        try {
            for (ProducerBatch batch : this.incomplete.copyAll()) {
                batch.produceFuture.await();
            }
        }
        finally {
            this.flushesInProgress.decrementAndGet();
        }
    }

    public boolean hasIncomplete() {
        return !this.incomplete.isEmpty();
    }

    public void abortIncompleteBatches() {
        do {
            this.abortBatches();
        } while (this.appendsInProgress());
        this.abortBatches();
        this.batches.clear();
    }

    private void abortBatches() {
        this.abortBatches(new KafkaException("Producer is closed forcefully."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortBatches(RuntimeException reason) {
        for (ProducerBatch batch : this.incomplete.copyAll()) {
            Deque<ProducerBatch> dq;
            Deque<ProducerBatch> deque = dq = this.getDeque(batch.topicPartition);
            synchronized (deque) {
                batch.abortRecordAppends();
                dq.remove(batch);
            }
            batch.abort(reason);
            this.deallocate(batch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortUndrainedBatches(RuntimeException reason) {
        for (ProducerBatch batch : this.incomplete.copyAll()) {
            Deque<ProducerBatch> dq = this.getDeque(batch.topicPartition);
            boolean aborted = false;
            Deque<ProducerBatch> deque = dq;
            synchronized (deque) {
                if (this.transactionManager != null && !batch.hasSequence() || this.transactionManager == null && !batch.isClosed()) {
                    aborted = true;
                    batch.abortRecordAppends();
                    dq.remove(batch);
                }
            }
            if (!aborted) continue;
            batch.abort(reason);
            this.deallocate(batch);
        }
    }

    public void mutePartition(TopicPartition tp) {
        this.muted.put(tp, Long.MAX_VALUE);
    }

    public void unmutePartition(TopicPartition tp, long throttleUntilTimeMs) {
        this.muted.put(tp, throttleUntilTimeMs);
    }

    public void close() {
        this.closed = true;
    }

    public static final class ReadyCheckResult {
        public final Set<Node> readyNodes;
        public final long nextReadyCheckDelayMs;
        public final Set<String> unknownLeaderTopics;

        public ReadyCheckResult(Set<Node> readyNodes, long nextReadyCheckDelayMs, Set<String> unknownLeaderTopics) {
            this.readyNodes = readyNodes;
            this.nextReadyCheckDelayMs = nextReadyCheckDelayMs;
            this.unknownLeaderTopics = unknownLeaderTopics;
        }
    }

    public static final class RecordAppendResult {
        public final FutureRecordMetadata future;
        public final boolean batchIsFull;
        public final boolean newBatchCreated;

        public RecordAppendResult(FutureRecordMetadata future, boolean batchIsFull, boolean newBatchCreated) {
            this.future = future;
            this.batchIsFull = batchIsFull;
            this.newBatchCreated = newBatchCreated;
        }
    }
}

