/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;

public class HeartbeatRequestData
implements ApiMessage {
    private String groupId;
    private int generationid;
    private String memberId;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public HeartbeatRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public HeartbeatRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public HeartbeatRequestData() {
        this.groupId = "";
        this.generationid = 0;
        this.memberId = "";
    }

    @Override
    public short apiKey() {
        return 12;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        this.groupId = readable.readNullableString();
        this.generationid = readable.readInt();
        this.memberId = readable.readNullableString();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeString(this.groupId);
        writable.writeInt(this.generationid);
        writable.writeString(this.memberId);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.groupId = struct.getString("group_id");
        this.generationid = struct.getInt("generationid");
        this.memberId = struct.getString("member_id");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("group_id", (Object)this.groupId);
        struct.set("generationid", (Object)this.generationid);
        struct.set("member_id", (Object)this.memberId);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.groupId);
        size += 4;
        size += 2;
        return size += MessageUtil.serializedUtf8Length(this.memberId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HeartbeatRequestData)) {
            return false;
        }
        HeartbeatRequestData other = (HeartbeatRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.generationid != other.generationid) {
            return false;
        }
        return !(this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + this.generationid;
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        return hashCode;
    }

    public String toString() {
        return "HeartbeatRequestData(groupId='" + this.groupId + "', generationid=" + this.generationid + ", memberId='" + this.memberId + "')";
    }

    public String groupId() {
        return this.groupId;
    }

    public int generationid() {
        return this.generationid;
    }

    public String memberId() {
        return this.memberId;
    }

    public HeartbeatRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public HeartbeatRequestData setGenerationid(int v) {
        this.generationid = v;
        return this;
    }

    public HeartbeatRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The group id."), new Field("generationid", Type.INT32, "The generation of the group."), new Field("member_id", Type.STRING, "The member ID.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

