/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.util.Arrays;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Bytes;

public class SaslAuthenticateRequestData
implements ApiMessage {
    private byte[] authBytes;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public SaslAuthenticateRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public SaslAuthenticateRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public SaslAuthenticateRequestData() {
        this.authBytes = Bytes.EMPTY;
    }

    @Override
    public short apiKey() {
        return 36;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable readable, short version) {
        this.authBytes = readable.readNullableBytes();
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeBytes(this.authBytes);
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.authBytes = struct.getByteArray("auth_bytes");
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.setByteArray("auth_bytes", this.authBytes);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 4;
        return size += this.authBytes.length;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SaslAuthenticateRequestData)) {
            return false;
        }
        SaslAuthenticateRequestData other = (SaslAuthenticateRequestData)obj;
        return Arrays.equals(this.authBytes, other.authBytes);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Arrays.hashCode(this.authBytes);
        return hashCode;
    }

    public String toString() {
        return "SaslAuthenticateRequestData(authBytes=" + Arrays.toString(this.authBytes) + ")";
    }

    public byte[] authBytes() {
        return this.authBytes;
    }

    public SaslAuthenticateRequestData setAuthBytes(byte[] v) {
        this.authBytes = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("auth_bytes", Type.BYTES, "The SASL authentication bytes from the client, as defined by the SASL mechanism."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

