/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ListGroupsResponse;

public class ListGroupsRequest
extends AbstractRequest {
    private static final Schema LIST_GROUPS_REQUEST_V0;
    private static final Schema LIST_GROUPS_REQUEST_V1;
    private static final Schema LIST_GROUPS_REQUEST_V2;

    public static Schema[] schemaVersions() {
        return new Schema[]{LIST_GROUPS_REQUEST_V0, LIST_GROUPS_REQUEST_V1, LIST_GROUPS_REQUEST_V2};
    }

    public ListGroupsRequest(short version) {
        super(ApiKeys.LIST_GROUPS, version);
    }

    public ListGroupsRequest(Struct struct, short versionId) {
        super(ApiKeys.LIST_GROUPS, versionId);
    }

    @Override
    public ListGroupsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new ListGroupsResponse(Errors.forException(e), Collections.emptyList());
            }
            case 1: 
            case 2: {
                return new ListGroupsResponse(throttleTimeMs, Errors.forException(e), Collections.emptyList());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.LIST_GROUPS.latestVersion()));
    }

    public static ListGroupsRequest parse(ByteBuffer buffer, short version) {
        return new ListGroupsRequest(ApiKeys.LIST_GROUPS.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return new Struct(ApiKeys.LIST_GROUPS.requestSchema(this.version()));
    }

    static {
        LIST_GROUPS_REQUEST_V2 = LIST_GROUPS_REQUEST_V1 = (LIST_GROUPS_REQUEST_V0 = new Schema(new Field[0]));
    }

    public static class Builder
    extends AbstractRequest.Builder<ListGroupsRequest> {
        public Builder() {
            super(ApiKeys.LIST_GROUPS);
        }

        @Override
        public ListGroupsRequest build(short version) {
            return new ListGroupsRequest(version);
        }

        public String toString() {
            return "(type=ListGroupsRequest)";
        }
    }
}

