/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.CollectionUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;

public class StopReplicaRequest
extends AbstractControlRequest {
    private static final Field.Bool DELETE_PARTITIONS = new Field.Bool("delete_partitions", "Boolean which indicates if replica's partitions must be deleted.");
    private static final Field.ComplexArray PARTITIONS = new Field.ComplexArray("partitions", "The partitions");
    private static final Field.Array PARTITION_IDS = new Field.Array("partition_ids", Type.INT32, "The partition ids of a topic");
    private static final Field PARTITIONS_V0 = PARTITIONS.withFields(CommonFields.TOPIC_NAME, CommonFields.PARTITION_ID);
    private static final Field PARTITIONS_V1 = PARTITIONS.withFields(CommonFields.TOPIC_NAME, PARTITION_IDS);
    private static final Schema STOP_REPLICA_REQUEST_V0 = new Schema(CONTROLLER_ID, CONTROLLER_EPOCH, DELETE_PARTITIONS, PARTITIONS_V0);
    private static final Schema STOP_REPLICA_REQUEST_V1 = new Schema(CONTROLLER_ID, CONTROLLER_EPOCH, BROKER_EPOCH, DELETE_PARTITIONS, PARTITIONS_V1);
    private final boolean deletePartitions;
    private final Set<TopicPartition> partitions;

    public static Schema[] schemaVersions() {
        return new Schema[]{STOP_REPLICA_REQUEST_V0, STOP_REPLICA_REQUEST_V1};
    }

    private StopReplicaRequest(int controllerId, int controllerEpoch, long brokerEpoch, boolean deletePartitions, Set<TopicPartition> partitions, short version) {
        super(ApiKeys.STOP_REPLICA, version, controllerId, controllerEpoch, brokerEpoch);
        this.deletePartitions = deletePartitions;
        this.partitions = partitions;
    }

    public StopReplicaRequest(Struct struct, short version) {
        super(ApiKeys.STOP_REPLICA, struct, version);
        this.partitions = new HashSet<TopicPartition>();
        if (version > 0) {
            for (Object topicObj : struct.get(PARTITIONS)) {
                Struct topicData = (Struct)topicObj;
                String topic = topicData.get(CommonFields.TOPIC_NAME);
                for (Object partitionObj : topicData.get(PARTITION_IDS)) {
                    int partition = (Integer)partitionObj;
                    this.partitions.add(new TopicPartition(topic, partition));
                }
            }
        } else {
            for (Object partitionDataObj : struct.get(PARTITIONS)) {
                Struct partitionData = (Struct)partitionDataObj;
                String topic = partitionData.get(CommonFields.TOPIC_NAME);
                int partition = partitionData.get(CommonFields.PARTITION_ID);
                this.partitions.add(new TopicPartition(topic, partition));
            }
        }
        this.deletePartitions = struct.get(DELETE_PARTITIONS);
    }

    @Override
    public StopReplicaResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<TopicPartition, Errors> responses = new HashMap<TopicPartition, Errors>(this.partitions.size());
        for (TopicPartition partition : this.partitions) {
            responses.put(partition, error);
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new StopReplicaResponse(error, responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.STOP_REPLICA.latestVersion()));
    }

    public boolean deletePartitions() {
        return this.deletePartitions;
    }

    public Set<TopicPartition> partitions() {
        return this.partitions;
    }

    public static StopReplicaRequest parse(ByteBuffer buffer, short version) {
        return new StopReplicaRequest(ApiKeys.STOP_REPLICA.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.STOP_REPLICA.requestSchema(this.version()));
        struct.set(CONTROLLER_ID, this.controllerId);
        struct.set(CONTROLLER_EPOCH, this.controllerEpoch);
        struct.setIfExists(BROKER_EPOCH, (Object)this.brokerEpoch);
        struct.set(DELETE_PARTITIONS, this.deletePartitions);
        if (this.version() > 0) {
            Map<String, List<Integer>> topicPartitionsMap = CollectionUtils.groupPartitionsByTopic(this.partitions);
            ArrayList<Struct> topicsData = new ArrayList<Struct>(topicPartitionsMap.size());
            for (Map.Entry<String, List<Integer>> entry : topicPartitionsMap.entrySet()) {
                Struct topicData = struct.instance(PARTITIONS);
                topicData.set(CommonFields.TOPIC_NAME, entry.getKey());
                topicData.set(PARTITION_IDS, entry.getValue().toArray());
                topicsData.add(topicData);
            }
            struct.set(PARTITIONS, topicsData.toArray());
        } else {
            ArrayList<Struct> partitionDatas = new ArrayList<Struct>(this.partitions.size());
            for (TopicPartition partition : this.partitions) {
                Struct partitionData = struct.instance(PARTITIONS);
                partitionData.set(CommonFields.TOPIC_NAME, partition.topic());
                partitionData.set(CommonFields.PARTITION_ID, partition.partition());
                partitionDatas.add(partitionData);
            }
            struct.set(PARTITIONS, partitionDatas.toArray());
        }
        return struct;
    }

    public static class Builder
    extends AbstractControlRequest.Builder<StopReplicaRequest> {
        private final boolean deletePartitions;
        private final Set<TopicPartition> partitions;

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, boolean deletePartitions, Set<TopicPartition> partitions) {
            super(ApiKeys.STOP_REPLICA, version, controllerId, controllerEpoch, brokerEpoch);
            this.deletePartitions = deletePartitions;
            this.partitions = partitions;
        }

        @Override
        public StopReplicaRequest build(short version) {
            return new StopReplicaRequest(this.controllerId, this.controllerEpoch, this.brokerEpoch, this.deletePartitions, this.partitions, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=StopReplicaRequest").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", deletePartitions=").append(this.deletePartitions).append(", brokerEpoch=").append(this.brokerEpoch).append(", partitions=").append(Utils.join(this.partitions, ",")).append(")");
            return bld.toString();
        }
    }
}

