/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.RequestUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class TxnOffsetCommitRequest
extends AbstractRequest {
    private static final Field.ComplexArray TOPICS = new Field.ComplexArray("topics", "Topics to commit offsets");
    private static final Field.ComplexArray PARTITIONS = new Field.ComplexArray("partitions", "Partitions to commit offsets");
    private static final Field PARTITIONS_V0 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.COMMITTED_OFFSET, CommonFields.COMMITTED_METADATA);
    private static final Field TOPICS_V0 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V0);
    private static final Schema TXN_OFFSET_COMMIT_REQUEST_V0;
    private static final Schema TXN_OFFSET_COMMIT_REQUEST_V1;
    private static final Field PARTITIONS_V2;
    private static final Field TOPICS_V2;
    private static final Schema TXN_OFFSET_COMMIT_REQUEST_V2;
    private final String transactionalId;
    private final String consumerGroupId;
    private final long producerId;
    private final short producerEpoch;
    private final Map<TopicPartition, CommittedOffset> offsets;

    public static Schema[] schemaVersions() {
        return new Schema[]{TXN_OFFSET_COMMIT_REQUEST_V0, TXN_OFFSET_COMMIT_REQUEST_V1, TXN_OFFSET_COMMIT_REQUEST_V2};
    }

    public TxnOffsetCommitRequest(short version, String transactionalId, String consumerGroupId, long producerId, short producerEpoch, Map<TopicPartition, CommittedOffset> offsets) {
        super(ApiKeys.TXN_OFFSET_COMMIT, version);
        this.transactionalId = transactionalId;
        this.consumerGroupId = consumerGroupId;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.offsets = offsets;
    }

    public TxnOffsetCommitRequest(Struct struct, short version) {
        super(ApiKeys.TXN_OFFSET_COMMIT, version);
        Object[] topicPartitionsArray;
        this.transactionalId = struct.get(CommonFields.TRANSACTIONAL_ID);
        this.consumerGroupId = struct.get(CommonFields.GROUP_ID);
        this.producerId = struct.get(CommonFields.PRODUCER_ID);
        this.producerEpoch = struct.get(CommonFields.PRODUCER_EPOCH);
        HashMap<TopicPartition, CommittedOffset> offsets = new HashMap<TopicPartition, CommittedOffset>();
        for (Object topicPartitionObj : topicPartitionsArray = struct.get(TOPICS)) {
            Struct topicPartitionStruct = (Struct)topicPartitionObj;
            String topic = topicPartitionStruct.get(CommonFields.TOPIC_NAME);
            for (Object partitionObj : topicPartitionStruct.get(PARTITIONS)) {
                Struct partitionStruct = (Struct)partitionObj;
                TopicPartition partition = new TopicPartition(topic, partitionStruct.get(CommonFields.PARTITION_ID));
                long offset = partitionStruct.get(CommonFields.COMMITTED_OFFSET);
                String metadata = partitionStruct.get(CommonFields.COMMITTED_METADATA);
                Optional<Integer> leaderEpoch = RequestUtils.getLeaderEpoch(partitionStruct, CommonFields.COMMITTED_LEADER_EPOCH);
                offsets.put(partition, new CommittedOffset(offset, metadata, leaderEpoch));
            }
        }
        this.offsets = offsets;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public String consumerGroupId() {
        return this.consumerGroupId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public Map<TopicPartition, CommittedOffset> offsets() {
        return this.offsets;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.TXN_OFFSET_COMMIT.requestSchema(this.version()));
        struct.set(CommonFields.TRANSACTIONAL_ID, this.transactionalId);
        struct.set(CommonFields.GROUP_ID, this.consumerGroupId);
        struct.set(CommonFields.PRODUCER_ID, this.producerId);
        struct.set(CommonFields.PRODUCER_EPOCH, this.producerEpoch);
        Map<String, Map<Integer, CommittedOffset>> mappedPartitionOffsets = CollectionUtils.groupPartitionDataByTopic(this.offsets);
        Object[] partitionsArray = new Object[mappedPartitionOffsets.size()];
        int i = 0;
        for (Map.Entry<String, Map<Integer, CommittedOffset>> topicAndPartitions : mappedPartitionOffsets.entrySet()) {
            Struct topicPartitionsStruct = struct.instance(TOPICS);
            topicPartitionsStruct.set(CommonFields.TOPIC_NAME, topicAndPartitions.getKey());
            Map<Integer, CommittedOffset> partitionOffsets = topicAndPartitions.getValue();
            Object[] partitionOffsetsArray = new Object[partitionOffsets.size()];
            int j = 0;
            for (Map.Entry<Integer, CommittedOffset> partitionOffset : partitionOffsets.entrySet()) {
                Struct partitionOffsetStruct = topicPartitionsStruct.instance(PARTITIONS);
                partitionOffsetStruct.set(CommonFields.PARTITION_ID, partitionOffset.getKey());
                CommittedOffset committedOffset = partitionOffset.getValue();
                partitionOffsetStruct.set(CommonFields.COMMITTED_OFFSET, committedOffset.offset);
                partitionOffsetStruct.set(CommonFields.COMMITTED_METADATA, committedOffset.metadata);
                RequestUtils.setLeaderEpochIfExists(partitionOffsetStruct, CommonFields.COMMITTED_LEADER_EPOCH, committedOffset.leaderEpoch);
                partitionOffsetsArray[j++] = partitionOffsetStruct;
            }
            topicPartitionsStruct.set(PARTITIONS, partitionOffsetsArray);
            partitionsArray[i++] = topicPartitionsStruct;
        }
        struct.set(TOPICS, partitionsArray);
        return struct;
    }

    @Override
    public TxnOffsetCommitResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>(this.offsets.size());
        for (TopicPartition partition : this.offsets.keySet()) {
            errors.put(partition, error);
        }
        return new TxnOffsetCommitResponse(throttleTimeMs, errors);
    }

    public static TxnOffsetCommitRequest parse(ByteBuffer buffer, short version) {
        return new TxnOffsetCommitRequest(ApiKeys.TXN_OFFSET_COMMIT.parseRequest(version, buffer), version);
    }

    static {
        TXN_OFFSET_COMMIT_REQUEST_V1 = TXN_OFFSET_COMMIT_REQUEST_V0 = new Schema(CommonFields.TRANSACTIONAL_ID, CommonFields.GROUP_ID, CommonFields.PRODUCER_ID, CommonFields.PRODUCER_EPOCH, TOPICS_V0);
        PARTITIONS_V2 = PARTITIONS.withFields(CommonFields.PARTITION_ID, CommonFields.COMMITTED_OFFSET, CommonFields.COMMITTED_LEADER_EPOCH, CommonFields.COMMITTED_METADATA);
        TOPICS_V2 = TOPICS.withFields(CommonFields.TOPIC_NAME, PARTITIONS_V2);
        TXN_OFFSET_COMMIT_REQUEST_V2 = new Schema(CommonFields.TRANSACTIONAL_ID, CommonFields.GROUP_ID, CommonFields.PRODUCER_ID, CommonFields.PRODUCER_EPOCH, TOPICS_V2);
    }

    public static class CommittedOffset {
        public final long offset;
        public final String metadata;
        public final Optional<Integer> leaderEpoch;

        public CommittedOffset(long offset, String metadata, Optional<Integer> leaderEpoch) {
            this.offset = offset;
            this.metadata = metadata;
            this.leaderEpoch = leaderEpoch;
        }

        public String toString() {
            return "CommittedOffset(offset=" + this.offset + ", leaderEpoch=" + this.leaderEpoch + ", metadata='" + this.metadata + "')";
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<TxnOffsetCommitRequest> {
        private final String transactionalId;
        private final String consumerGroupId;
        private final long producerId;
        private final short producerEpoch;
        private final Map<TopicPartition, CommittedOffset> offsets;

        public Builder(String transactionalId, String consumerGroupId, long producerId, short producerEpoch, Map<TopicPartition, CommittedOffset> offsets) {
            super(ApiKeys.TXN_OFFSET_COMMIT);
            this.transactionalId = transactionalId;
            this.consumerGroupId = consumerGroupId;
            this.producerId = producerId;
            this.producerEpoch = producerEpoch;
            this.offsets = offsets;
        }

        public String consumerGroupId() {
            return this.consumerGroupId;
        }

        public Map<TopicPartition, CommittedOffset> offsets() {
            return this.offsets;
        }

        @Override
        public TxnOffsetCommitRequest build(short version) {
            return new TxnOffsetCommitRequest(version, this.transactionalId, this.consumerGroupId, this.producerId, this.producerEpoch, this.offsets);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=TxnOffsetCommitRequest").append(", transactionalId=").append(this.transactionalId).append(", producerId=").append(this.producerId).append(", producerEpoch=").append(this.producerEpoch).append(", consumerGroupId=").append(this.consumerGroupId).append(", offsets=").append(this.offsets).append(")");
            return bld.toString();
        }
    }
}

