/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.Callback;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.Producer;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals.TransactionalRequestResult;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Metric;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.MetricName;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Node;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.PartitionInfo;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class FlinkKafkaInternalProducer<K, V>
implements Producer<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkKafkaInternalProducer.class);
    protected final KafkaProducer<K, V> kafkaProducer;
    private final Object producerClosingLock;
    private volatile boolean closed;
    @Nullable
    protected final String transactionalId;

    public FlinkKafkaInternalProducer(Properties properties) {
        this.transactionalId = properties.getProperty("transactional.id");
        this.kafkaProducer = new KafkaProducer(properties);
        this.producerClosingLock = new Object();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initTransactions() {
        Object object = this.producerClosingLock;
        synchronized (object) {
            this.ensureNotClosed();
            this.kafkaProducer.initTransactions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransaction() throws ProducerFencedException {
        Object object = this.producerClosingLock;
        synchronized (object) {
            this.ensureNotClosed();
            this.kafkaProducer.beginTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitTransaction() throws ProducerFencedException {
        Object object = this.producerClosingLock;
        synchronized (object) {
            this.ensureNotClosed();
            this.kafkaProducer.commitTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortTransaction() throws ProducerFencedException {
        Object object = this.producerClosingLock;
        synchronized (object) {
            this.ensureNotClosed();
            this.kafkaProducer.abortTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
        Object object = this.producerClosingLock;
        synchronized (object) {
            this.ensureNotClosed();
            this.kafkaProducer.sendOffsetsToTransaction(offsets, consumerGroupId);
        }
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.kafkaProducer.send(record);
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        return this.kafkaProducer.send(record, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        Object object = this.producerClosingLock;
        synchronized (object) {
            this.ensureNotClosed();
            return this.kafkaProducer.partitionsFor(topic);
        }
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        return this.kafkaProducer.metrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.closed = true;
        Object object = this.producerClosingLock;
        synchronized (object) {
            this.kafkaProducer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long timeout, TimeUnit unit) {
        this.closed = true;
        Object object = this.producerClosingLock;
        synchronized (object) {
            this.kafkaProducer.close(timeout, unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Duration duration) {
        this.closed = true;
        Object object = this.producerClosingLock;
        synchronized (object) {
            this.kafkaProducer.close(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.kafkaProducer.flush();
        if (this.transactionalId != null) {
            Object object = this.producerClosingLock;
            synchronized (object) {
                this.ensureNotClosed();
                this.flushNewPartitions();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTransaction(long producerId, short epoch) {
        Object object = this.producerClosingLock;
        synchronized (object) {
            Object transactionManager;
            this.ensureNotClosed();
            Preconditions.checkState((producerId >= 0L && epoch >= 0 ? 1 : 0) != 0, (String)"Incorrect values for producerId %s and epoch %s", (Object[])new Object[]{producerId, epoch});
            LOG.info("Attempting to resume transaction {} with producerId {} and epoch {}", new Object[]{this.transactionalId, producerId, epoch});
            Object object2 = transactionManager = FlinkKafkaInternalProducer.getValue(this.kafkaProducer, "transactionManager");
            synchronized (object2) {
                Object nextSequence = FlinkKafkaInternalProducer.getValue(transactionManager, "nextSequence");
                FlinkKafkaInternalProducer.invoke(transactionManager, "transitionTo", FlinkKafkaInternalProducer.getEnum("org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals.TransactionManager$State.INITIALIZING"));
                FlinkKafkaInternalProducer.invoke(nextSequence, "clear", new Object[0]);
                Object producerIdAndEpoch = FlinkKafkaInternalProducer.getValue(transactionManager, "producerIdAndEpoch");
                FlinkKafkaInternalProducer.setValue(producerIdAndEpoch, "producerId", producerId);
                FlinkKafkaInternalProducer.setValue(producerIdAndEpoch, "epoch", epoch);
                FlinkKafkaInternalProducer.invoke(transactionManager, "transitionTo", FlinkKafkaInternalProducer.getEnum("org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals.TransactionManager$State.READY"));
                FlinkKafkaInternalProducer.invoke(transactionManager, "transitionTo", FlinkKafkaInternalProducer.getEnum("org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals.TransactionManager$State.IN_TRANSACTION"));
                FlinkKafkaInternalProducer.setValue(transactionManager, "transactionStarted", true);
            }
        }
    }

    public String getTransactionalId() {
        return this.transactionalId;
    }

    public long getProducerId() {
        Object transactionManager = FlinkKafkaInternalProducer.getValue(this.kafkaProducer, "transactionManager");
        Object producerIdAndEpoch = FlinkKafkaInternalProducer.getValue(transactionManager, "producerIdAndEpoch");
        return (Long)FlinkKafkaInternalProducer.getValue(producerIdAndEpoch, "producerId");
    }

    public short getEpoch() {
        Object transactionManager = FlinkKafkaInternalProducer.getValue(this.kafkaProducer, "transactionManager");
        Object producerIdAndEpoch = FlinkKafkaInternalProducer.getValue(transactionManager, "producerIdAndEpoch");
        return (Short)FlinkKafkaInternalProducer.getValue(producerIdAndEpoch, "epoch");
    }

    @VisibleForTesting
    public int getTransactionCoordinatorId() {
        Object transactionManager = FlinkKafkaInternalProducer.getValue(this.kafkaProducer, "transactionManager");
        Node node = (Node)FlinkKafkaInternalProducer.invoke(transactionManager, "coordinator", new Object[]{FindCoordinatorRequest.CoordinatorType.TRANSACTION});
        return node.id();
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("The producer has already been closed");
        }
    }

    private void flushNewPartitions() {
        LOG.info("Flushing new partitions");
        TransactionalRequestResult result = this.enqueueNewPartitions();
        Object sender = FlinkKafkaInternalProducer.getValue(this.kafkaProducer, "sender");
        FlinkKafkaInternalProducer.invoke(sender, "wakeup", new Object[0]);
        result.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionalRequestResult enqueueNewPartitions() {
        Object transactionManager;
        Object object = transactionManager = FlinkKafkaInternalProducer.getValue(this.kafkaProducer, "transactionManager");
        synchronized (object) {
            TransactionalRequestResult result;
            Object newPartitionsInTransaction = FlinkKafkaInternalProducer.getValue(transactionManager, "newPartitionsInTransaction");
            Object newPartitionsInTransactionIsEmpty = FlinkKafkaInternalProducer.invoke(newPartitionsInTransaction, "isEmpty", new Object[0]);
            if (newPartitionsInTransactionIsEmpty instanceof Boolean && !((Boolean)newPartitionsInTransactionIsEmpty).booleanValue()) {
                Object txnRequestHandler = FlinkKafkaInternalProducer.invoke(transactionManager, "addPartitionsToTransactionHandler", new Object[0]);
                FlinkKafkaInternalProducer.invoke(transactionManager, "enqueueRequest", new Class[]{txnRequestHandler.getClass().getSuperclass()}, new Object[]{txnRequestHandler});
                result = (TransactionalRequestResult)FlinkKafkaInternalProducer.getValue(txnRequestHandler, txnRequestHandler.getClass().getSuperclass(), "result");
            } else {
                result = new TransactionalRequestResult();
                result.done();
            }
            return result;
        }
    }

    protected static Enum<?> getEnum(String enumFullName) {
        String[] x = enumFullName.split("\\.(?=[^\\.]+$)");
        if (x.length == 2) {
            String enumClassName = x[0];
            String enumName = x[1];
            try {
                Class<?> cl = Class.forName(enumClassName);
                return Enum.valueOf(cl, enumName);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Incompatible KafkaProducer version", e);
            }
        }
        return null;
    }

    protected static Object invoke(Object object, String methodName, Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return FlinkKafkaInternalProducer.invoke(object, methodName, argTypes, args);
    }

    private static Object invoke(Object object, String methodName, Class<?>[] argTypes, Object[] args) {
        try {
            Method method = object.getClass().getDeclaredMethod(methodName, argTypes);
            method.setAccessible(true);
            return method.invoke(object, args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }

    protected static Object getValue(Object object, String fieldName) {
        return FlinkKafkaInternalProducer.getValue(object, object.getClass(), fieldName);
    }

    private static Object getValue(Object object, Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }

    protected static void setValue(Object object, String fieldName, Object value) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Incompatible KafkaProducer version", e);
        }
    }
}

