/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.jdbc.JDBCAppendTableSink;
import org.apache.flink.api.java.io.jdbc.JDBCOutputFormat;
import org.apache.flink.api.java.io.jdbc.JDBCTypeUtil;
import org.apache.flink.util.Preconditions;

public class JDBCAppendTableSinkBuilder {
    private String username;
    private String password;
    private String driverName;
    private String dbURL;
    private String query;
    private int batchSize = 5000;
    private int[] parameterTypes;

    public JDBCAppendTableSinkBuilder setUsername(String username) {
        this.username = username;
        return this;
    }

    public JDBCAppendTableSinkBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    public JDBCAppendTableSinkBuilder setDrivername(String drivername) {
        this.driverName = drivername;
        return this;
    }

    public JDBCAppendTableSinkBuilder setDBUrl(String dbURL) {
        this.dbURL = dbURL;
        return this;
    }

    public JDBCAppendTableSinkBuilder setQuery(String query) {
        this.query = query;
        return this;
    }

    public JDBCAppendTableSinkBuilder setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public JDBCAppendTableSinkBuilder setParameterTypes(TypeInformation<?> ... types) {
        int[] ty = new int[types.length];
        for (int i = 0; i < types.length; ++i) {
            ty[i] = JDBCTypeUtil.typeInformationToSqlType(types[i]);
        }
        this.parameterTypes = ty;
        return this;
    }

    public JDBCAppendTableSinkBuilder setParameterTypes(int ... types) {
        this.parameterTypes = types;
        return this;
    }

    public JDBCAppendTableSink build() {
        Preconditions.checkNotNull((Object)this.parameterTypes, (String)"Types of the query parameters are not specified. Please specify types using the setParameterTypes() method.");
        JDBCOutputFormat format = JDBCOutputFormat.buildJDBCOutputFormat().setUsername(this.username).setPassword(this.password).setDBUrl(this.dbURL).setQuery(this.query).setDrivername(this.driverName).setBatchInterval(this.batchSize).setSqlTypes(this.parameterTypes).finish();
        return new JDBCAppendTableSink(format);
    }
}

