/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.sv;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.CharArraySet;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.StopFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.WordlistLoader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.IOUtils;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.SwedishStemmer;

public final class SwedishAnalyzer
extends StopwordAnalyzerBase {
    private final CharArraySet stemExclusionSet;
    public static final String DEFAULT_STOPWORD_FILE = "swedish_stop.txt";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public SwedishAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public SwedishAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET);
    }

    public SwedishAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionSet) {
        super(stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionSet));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new StandardFilter(source);
        result = new LowerCaseFilter(result);
        result = new StopFilter(result, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result = new SetKeywordMarkerFilter(result, this.stemExclusionSet);
        }
        result = new SnowballFilter((TokenStream)result, (SnowballProgram)new SwedishStemmer());
        return new Analyzer.TokenStreamComponents(source, result);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new StandardFilter(in);
        result = new LowerCaseFilter(result);
        return result;
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet(IOUtils.getDecodingReader(SnowballFilter.class, SwedishAnalyzer.DEFAULT_STOPWORD_FILE, StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

