/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.prefix.tree.TreeCellIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

public abstract class SpatialPrefixTree {
    protected final int maxLevels;
    protected final SpatialContext ctx;

    public SpatialPrefixTree(SpatialContext ctx, int maxLevels) {
        assert (maxLevels > 0);
        this.ctx = ctx;
        this.maxLevels = maxLevels;
    }

    public SpatialContext getSpatialContext() {
        return this.ctx;
    }

    public int getMaxLevels() {
        return this.maxLevels;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(maxLevels:" + this.maxLevels + ",ctx:" + this.ctx + ")";
    }

    public abstract int getLevelForDistance(double var1);

    public abstract double getDistanceForLevel(int var1);

    public abstract Cell getWorldCell();

    public abstract Cell readCell(BytesRef var1, Cell var2);

    public CellIterator getTreeCellIterator(Shape shape, int detailLevel) {
        if (detailLevel > this.maxLevels) {
            throw new IllegalArgumentException("detailLevel > maxLevels");
        }
        return new TreeCellIterator(shape, detailLevel, this.getWorldCell());
    }
}

